/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_3 Page:411
//Title:Applying the Maxwell Relations
//===============================
package Ex11_3
  model Ex11_3_a
  //To use Redlich_Kwong equation of state
  
    //parameter selection
    parameter Real v(unit = "m3/kg") = 0.4646 "specific volume  of water vapour";
    parameter Real T(unit = "C") = 240 "temperature of water vapour";
    parameter Real a(unit = "m6.K1/2/kmol2") = 142.59 "Redlich-Kwong constant";
    parameter Real b(unit = "m3/kmol") = 0.0211 "Redlich-Kwong constant";
                                                                        /*From Table A-24 for water vapour. 
                                                                        Appendix Pg:A-45*/
    final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
    final constant Real M(final unit = "kg/kmol") = 18.02 "molecular mass of water vapour";
                                                                        /*From Table A-1. Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real vm(unit = "m3/kmol") "molar specific volume";
    Real dpdT_v(unit = "kJ/m3.K") "partial derivative";         //dpdT_v=(del P/del T)v
    Real dsdv_T(unit = "kJ/m3.K") "partial derivative";         //dsdv_T=(del s/del v)T
    //===============================
    
    //equation selection
    equation
      vm = v * M;
      dpdT_v = (R / (vm - b) + a * 10 ^ 5 / (2 * vm * (vm + b) * (T + 273.15) ^ 1.5)) * (1 / 10 ^ 3);
                                                                //Redlich-Kwong equation of state
                                                                //Differentiating w.r.t T
                                                                //Adding 273.15 to convert in Kelvin scale
                                                                //Dividing by 10^5 to convert into bar
      dsdv_T = dpdT_v;
  end Ex11_3_a;
  //===============================

  model Ex11_3_b
  //Using steam table data
  
      //===============================
      extends Ex11_3_a;
      //===============================
      
      //parameter selection
      parameter Real slope(unit="kJ/m3.K")=1.0"slope of tangent for entropy vs specific volume curve";
                                                                          /*From Fig. E11.3a at p=5 bar. Pg:412*/
      //===============================
      
      //variable selection
      Real error(unit="%")"error percentage";         //To store the error percentage value of dsdv_T
      String result;                                  //To store the result message
      //===============================
      
      //equation selection
      equation
      error=(dsdv_T-slope)/dsdv_T*100;
      if slope==dsdv_T then 
        result=" values match";
      else 
         if error<1 then 
          result=" values match";
         else 
          result=" values do not match";
         end if;
      end if;
      
      Modelica.Utilities.Streams.print(result);
  
  end Ex11_3_b;
  //===============================
end Ex11_3;
