/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_6 Page:441
//Title:Using Specific Heat Relations
//===============================
package Ex11_6
  model Ex11_6_a
    //To find percent of error
    
    //parameter selection
    parameter Real T(unit = "C") = 20 "temperature";
    parameter Real cp(unit = "kJ/kg.K") = 4.188 "specific heat at constant pressure";
                                                                      /*From Table A-19 at 
                                                                      T=20 C for water. 
                                                                      Appendix Pg:A-36*/
    parameter Real b(unit = "1/K") = 206.6e-6 "volume expansivity";
    parameter Real ki(unit = "1/bar") = 45.90e-6 "isothermal compressibility";
    parameter Real v(unit = "m3/kg") = 1 / 998.21 "specific volume";
                                                                      /*From Table 11.2 at 
                                                                      T=20 C, Pg:423*/
    //===============================
    
    //variable selection
    Real cv(unit = "kJ/kg.K") "specific heat at constant volume";
    Real error(unit = "%") "error percentage";
    Real cvp(unit = "kJ/kg.K") "difference of cp and cv";       //cvp=cp-cv
    
    //===============================
    
    //equation selection
  equation
    cvp = v * (T + 273.15) * b ^ 2 / ki * (10 ^ 5 / 10 ^ 3);    //From Eq.11.69, Pg:424
                                                                //Multiplying by 10^5 to convert into Pa
                                                                //Dividing by 10^3 to convert into kJ
                                                                //Adding 273.15 to convert into Kelvin scale
    cp - cv = cvp;
    error = (cp - cv) / cv * 100;
  end Ex11_6_a;

  //===============================

  model Ex11_6_b
    //To find velocity of sound
    
    //===============================
    extends Ex11_6_a;
    //===============================
    
    //parameter selection
    parameter Real k(unit = "-") = 1.006 "specific heat ratio";
    //===============================
    
    //variable selection
    Real c(unit = "m/s") "speed of sound";
    //===============================
    
    //equation selection
    equation
    c = (k * v / ki * 10 ^ 5) ^ 0.5;      //From Eq.11.65,Pg:423 and Eq.11.73, Pg:425
                                          //Multiplying by 10^5 to convert into Pa
  end Ex11_6_b;
  //===============================
end Ex11_6;
