/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_8 Page:435
//Title:Using the Generalized Enthalpy Departure Chart
//===============================
model Ex11_8

    //parameter selection
    parameter Real T1(unit="K")=300"inlet temperature";
    parameter Real T2(unit="K")=245"exit temperature";
    parameter Real p1(unit="bar")=100"inlet pressure";
    parameter Real p2(unit="bar")=40"exit pressure";
    parameter Real h1(unit="kJ/kg")=8723"specific enthalpy at inlet";     
                                                /*From Table A-23 at T=300 K for nitrogen. 
                                                Appendix Pg:A-41*/
    parameter Real h2(unit="kJ/kg")=7121"specific enthalpy at exit";
                                                /*From Table A-23 at T=245 K for nitrogen. 
                                                Appendix Pg:A-41*/
    parameter Real Tc(unit="K")=126"critical temperature";
    parameter Real pc(unit="bar")=33.9"critical pressure";    
                                                /*From Table A-1 for nitrogen. 
                                                Appendix Pg:A-2*/
    parameter Real hRTc1(unit="-")=0.5"correction factor for enthalpy change 1";      
                                                //hRTc1=((h* -h)/RTc)1
                                                /*From Fig.A-4 for TR=2.38 and pR=2.95. 
                                                Appendix Pg:A-99*/
    parameter Real hRTc2(unit="-")=0.31"correction factor for enthalpy change 2";     
                                                //hRTc2=((h* -h)/RTc)2
                                                /*From Fig.A-4 for TR=1.94 and pR=1.18. 
                                                Appendix Pg:A-99*/
    final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
    final constant Real M(final unit="kg/kmol")=28"molecular mass of nitrogen";
                                                /*From Table A-1. Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real TR1(unit="-")"reduced temperature at inlet";
    Real TR2(unit="-")"reduced temperature at exit";
    Real pR1(unit="-")"reduced pressure at inlet";
    Real pR2(unit="-")"reduced pressure at exit";
    Real Wcv_m(unit="kJ/kg")"work developed";
    //===============================
    
    //equation selection
    equation
      TR1=T1/Tc;
      TR2=T2/Tc;                                 //Reduced temperature
      pR1=p1/pc;
      pR2=p2/pc;                                 //Reduced pressure
      Wcv_m=(1/M)*(h1-h2-R*Tc*(hRTc1-hRTc2));    //From Eq.11.85, Pg:434
end Ex11_8;
//===============================
