/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_9 Page:437
//Title:Using the Generalized Entropy Departure Chart
//===============================
package Ex11_9
  model Ex11_9_a
  //To find entropy production rate
      
      //parameter selection
      parameter Real sT1(unit="kJ/kg.K")=191.682"specific entropy at inlet";  
                                                    /*From Table A-23 at T=300 K for nitrogen. 
                                                    Appendix Pg:A-41*/  
      parameter Real sT2(unit="kJ/kg.K")=185.775"specific entropy at exit";
                                                    /*From Table A-23 at T=245 K for nitrogen. 
                                                    Appendix Pg:A-41*/
      parameter Real p1(unit="bar")=100"inlet pressure";
      parameter Real p2(unit="bar")=40"exit pressure";
     
      parameter Real sR1(unit="-")=0.21"correction factor for entropy change 1";
                                                    //sR1=((s* -s)/R)1  
                                                    /*From Fig.A-5 for TR=2.38 and pR=2.95. 
                                                    Appendix Pg:A-100*/     
      parameter Real sR2(unit="-")=0.14"correction factor for entropy change 1";
                                                    //sR2=((s* -s)/R)2
                                                    /*From Fig.A-4 for TR=1.94 and pR=1.18. 
                                                    Appendix Pg:A-99*/
          final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
      final constant Real M(final unit="kg/kmol")=28"molecular mass of nitrogen";
                                                    /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real del_s(unit="kJ/kg.K")"specific entropy difference";        //del_s=s2-s1
      Real sigmacv_m(unit="kJ/kg.K")"entropy production rate";
      //===============================
      
      //equation selection
      equation
        del_s=sT2-sT1-R*log(p2/p1);
        sigmacv_m=1/M*(del_s-R*(sR2-sR1));                    //Change in specific entropy
        
  end Ex11_9_a;
  //===============================
  
  model Ex11_9_b  
  //To find isentropic turbine efficiency
  
      //parameter selection
      parameter Real T1(unit="K")=300"inlet temperature";
      parameter Real T2(unit="K")=245"exit temperature";
      parameter Real p1(unit="bar")=100"inlet pressure";
      parameter Real p2(unit="bar")=40"exit pressure";
      parameter Real h1(unit="kJ/kg")=8723"specific enthalpy at inlet";  
      parameter Real sT1(unit="kJ/kg.K")=191.682"specific entropy at inlet";
                                                    /*From Table A-23 at T=300 K for nitrogen. 
                                                    Appendix Pg:A-41*/
      parameter Real h2s(unit="kJ/kg")=6654"specific enthalpy at exit"; 
                                                    /*From Table A-23 at T=228 K for nitrogen. 
                                                    Appendix Pg:A-41*/
      parameter Real sR1(unit="-")=0.21"correction factor for entropy change 1";       
                                                    //sR1=((s* -s)/R)1  
                                                    /*From Fig.A-5 for TR=2.38 and pR=2.95. 
                                                    Appendix Pg:A-100*/     
      parameter Real hRTc1(unit="-")=0.5"correction factor for enthalpy change 1"; 
                                                    //hRTc1=((h* -h)/RTc)1
                                                    /*From Fig.A-4 for TR1=2.38 and pR1=2.95. 
                                                    Appendix Pg:A-99*/
      parameter Real hRTc2s(unit="-")=0.36"correction factor for enthalpy change 2";
                                                    //hRTc2s=((h* -h)/RTc)2s
                                                    /*From Fig.A-4 for TR=1.81 and pR=1.18. 
                                                    Appendix Pg:A-99*/
      parameter Real Wcv_m(unit="kJ/kg")=50.1"work developed";
      parameter Real Tc(unit="K")=126"critical temperature";        
                                                    /*From Table A-1 for nitrogen. 
                                                    Appendix Pg:A-2*/
      final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
      final constant Real M(final unit="kg/kmol")=28"molecular mass of nitrogen";
                                                    /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real Wcv_ms(unit="kJ/kg")"work developed";
      Real x(unit="kJ/kg.K")"specific entropy-entropy correction factor at state 2s";    //x=sT2s-R((s* -s)/R)2s
      Real nt(unit="-")"turbine efficiency";
      //===============================
      
      //equation selection
      equation
        x=1/M*(sT1+R*log(p2/p1)-R*sR1);               //From Eq. 11.92, Pg:437
        Wcv_ms=(1/M)*(h1-h2s-R*Tc*(hRTc1-hRTc2s));    //From Eq.11.85, Pg:434
        nt=Wcv_m/Wcv_ms;                              //Turbine efficiency
    
  end Ex11_9_b;
  //===============================
end Ex11_9;
