/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_10 Page:488
//Title:Heating Moist Air in a Duct
//===============================
package Ex12_10
  model Ex12_10_a
  //To find the rate of heat transfer
  
      //parameter selection
      parameter Real T1(unit = "C") = 10 "inlet temperature";
      parameter Real T2(unit = "C") = 30 "exit temperature";
      parameter Real AV1(unit = "m3/min") = 150 "volumetric flow rate";
      parameter Real phi1(unit = "-") = 0.80 "relative humidity at the inlet";
      parameter Real ha1(unit = "kJ/kg") = 283.1 "specific enthalpy of dry air at state 1";   
                                                                  /*From Table A-22 at T=283 K. 
                                                                  Appendix Pg:A-39*/
      parameter Real ha2(unit = "kJ/kg") = 303.2 "specific enthalpy of dry air at state 2";   
                                                                  /*From Table A-22 at T=303 K. 
                                                                  Appendix Pg:A-39*/
      parameter Real hv1(unit = "kJ/kg") = 2519.8 "specific enthalpy of water vapour at state 1";   
                                                                  /*From Table A-2 at T=10 C. 
                                                                  Appendix Pg:A-3*/
      parameter Real hv2(unit = "kJ/kg") = 2556.3 "specific enthalpy of water vapour at state 2";   
                                                                  /*From Table A-2 at T=30 C. 
                                                                  Appendix Pg:A-3*/
      parameter Real pg1(unit = "bar") = 0.01228 "saturation pressure at state 1";  
                                                                  /*From Table A-2 at T=10 C. 
                                                                  Appendix Pg:A-3*/
      parameter Real p(unit = "bar") = 1 "mixture pressure";
      final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
      final constant Real M(final unit = "kg/kmol") = 28.97 "molecular mass of air";
                                                                  /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real Qcv(unit = "kJ/min") "heat transfer rate";
      Real ma(unit = "kg/min") "mass flow rate of dry air";
      Real va1(unit = "m3/kg") "specific volume of dry air at state 1";
      Real pa1(unit = "bar") "partial pressure of dry air";
      Real pv1(unit = "bar") "partial pressure of water vapour at state 1";
      Real omega(unit = "kg(vapour)/kg(dry air)") "humidity ratio";
      //===============================
      
      //equation selection
      equation
        Qcv = ma * (ha2 - ha1 + omega * (hv2 - hv1));   //Reduced steady state energy rate balance
        ma = AV1 / va1;                                 //Mass flow rate
        va1 = R / M * (T1 + 273.15) / (pa1 * 10 ^ 5);   //Ideal gas equation of state
                                                        //Adding 273.15 to convert into Kelvin scale
                                                        //Multiplying 10^5 to convert into Pa
        pa1 = p - pv1;              
        pv1 = phi1 * pg1;                               //Partial pressure
        omega = 0.622 * pv1 / (p - pv1);                //From Eq.12.43, Pg:476
  end Ex12_10_a;

  //===============================

  model Ex12_10_b
  //To find relative humidity
      
      //===============================
      extends Ex12_10_a;
      //===============================
      
      //parameter selection
      parameter Real pg2(unit="bar")=0.04246"saturation pressure at state 2";      
                                                        /*From Table A-2 at T=30 C. 
                                                        Appendix Pg:A-3*/
      //===============================
      //variable selection
      Real phi2(unit="-")"relative humidity at the exit";
      Real pv2(unit="bar")"partial pressure of water vapour at exit";   
      //===============================
      
      //equation selection
      equation
        pv1=pv2;
        phi2=pv2/pg2;         //Relative humidity
        
  end Ex12_10_b;

  //===============================
end Ex12_10;
