/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_11 Page:491
//Title:Assessing Dehumidifier Performance
//===============================
package Ex12_11
  model Ex12_11_a
  //To find mass flow rate of dry air
  
      //parameter selection
      parameter Real AV1(unit = "m3/min") = 280 "volumetric flow rate";
      parameter Real T1(unit = "C") = 30 "temperature at inlet";
      parameter Real phi1(unit = "-") = 0.50 "relative humidity at inlet";
      parameter Real pg1(unit = "bar") = 0.04246 "saturation pressure for inlet";   
                                                          /*From Table A-2 at T=30 C. 
                                                          Appendix Pg:A-3*/
      parameter Real p1(unit = "bar") = 1.013 "total pressure";
      final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
      final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
                                                          /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real ma(unit = "kg/min") "mass flow rate of dry air";
      Real pv1(unit = "bar") "partial pressure of water vapour";
      Real pa1(unit = "bar") "partial pressure of dry air";
      //===============================
      
      //equation selection
      equation
       ma = AV1 / (R / Ma * ((T1 + 273.15) / (pa1 * 10 ^ 5))); //Mass flow rate with ideal gas equation of state
       pv1 = phi1 * pg1;                                       //Partial pressure
       pa1 = p1 - pv1;
  end Ex12_11_a;
  //===============================

  model Ex12_11_b
  //To find the rate of water condensation
  
      //===============================
      extends Ex12_11_a;
      //===============================  
      
      //parameter selection
      parameter Real pg2(unit="bar")=0.01228"saturation pressure for exit";  
                                                      /*From Table A-2 at T=10 C. 
                                                      Appendix Pg:A-3*/
      //===============================
      
      //variable selection
      Real pv2(unit="bar")"partial water vapour presure at exit";
      Real omega1(unit="-")"humidity ratio for inlet";
      Real omega2(unit="-")"humidity ratio for the exit";
      Real mw_ma(unit="kg(condensate)/kg(dry air)")"water is condensed per unit mass of dry air";   
                                                                                    //mw_ma=mw/ma
      //===============================
      
      //equation selection
      equation
        pg2=pv2;
        mw_ma=omega1-omega2;                         //From conservation of mass and humidity ratio
        omega1=0.622 * pv1 / (p1 - pv1); 
        omega2=0.622 * pv2 / (p1 - pv2);             //From Eq.12.43, Pg:476               
  end Ex12_11_b;
  //===============================

  model Ex12_11_c
  //To find the refrigeration capacity
  
      //===============================
      extends Ex12_11_a;
      extends Ex12_11_b;
      //===============================
  
      //parameter selection
      parameter Real ha1(unit = "kJ/kg") = 303.2 "specific enthalpy of dry air at state 1";   
                                                                  /*From Table A-22 at T=303 K. 
                                                                  Appendix Pg:A-39*/
      parameter Real ha2(unit = "kJ/kg") =283.1  "specific enthalpy of dry air at state 2";   
                                                                  /*From Table A-22 at T=283 K. 
                                                                  Appendix Pg:A-39*/
      parameter Real hg2(unit = "kJ/kg") = 2519.8 "specific enthalpy of water vapour at state 2";   
                                                                  /*From Table A-2 at T=10 C. 
                                                                  Appendix Pg:A-3*/
      parameter Real hg1(unit = "kJ/kg") = 2556.3 "specific enthalpy of water vapour at state 1";   
                                                                  /*From Table A-2 at T=30 C. 
                                                                  Appendix Pg:A-3*/
      parameter Real hf2(unit = "kJ/kg") = 42.01 "specific enthalpy of exiting condensate at state 2";   
                                                                  /*From Table A-2 at T=10 C. 
                                                                  Appendix Pg:A-3*/
      //===============================
      
      //variable selection
      Real Qcv(unit="kJ/min")"heat transfer rate";
      Real rc(unit="tons")"refrigeration capacity";
      //===============================
      
      //equation selection  
      equation
        Qcv=ma*((ha2-ha1)-omega1*hg1+omega2*hg2+(omega1-omega2)*hf2); //Reduced steady state energy rate balance
        rc=Qcv/211*(-1);                                              //Dividing by 211 to convert into tons
                                                    //Multiplying by -1 to convert into positive number
  
  end Ex12_11_c;
  //===============================
end Ex12_11;
