/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_12 Page:493
//Title:Analyzing a Steam-Spray Humidifier
//===============================
package Ex12_12
  model Ex12_12_a
  //To find the exit humidity ratio
  
      //parameter selection
      parameter Real ma(unit = "kg/min") = 90 "mass flow rate of dry air";
      parameter Real mst(unit = "kg/h") = 52 "mass flow rate of saturated vapour";
      parameter Real omega1(unit = "kg(vapour)/kg(dry air)") = 0.002 "humidity ratio at inlet";
      //===============================
      
      //variable selection
      Real omega2(unit = "kg(vapour)/kg(dry air)") "humidity ratio at exit";
      //===============================
      
      //equation selection
      equation
        omega2 = omega1 + mst * (1 / 60) / ma;   //From humidity ratio and mass flow rate balance
                                                 //Dividing by 60 to convert into h
  end Ex12_12_a;
  //===============================

  model Ex12_12_b
  //To find exit temperature
  
      //===============================
      extends Ex12_12_a;
      //===============================
      
      //parameter selection
      parameter Real hag_1(unit="kJ/kg")=27.2"specific enthalpy of air and satuarted vapour at state 1";    
                                                               //hag_1=(ha+w.hg)1
                                                               /*From Fig.A-9 at dry bulb temperature=22 C 
                                                               and wet bulb temperature=9 C. 
                                                               Appendix Pg:A-106*/
      parameter Real hg3(unit="kJ/kg")=2691.5"enthalpy of the saturated vapor injected";
                                                               /*From Table A-2 at T=110 C 
                                                               for saturated vapour. Appendix Pg:A-4*/
       //===============================
       
       //variable selection
       Real hag_2(unit="kJ/kg")"specific enthalpy of air and saturated vapour value at state 2";       
                                                                              //hag_2=(ha+w.hg)2
       //===============================
       
       //equation selection
       equation
        hag_2 =  hag_1 + (omega2-omega1)*hg3;         //From Eq.12.55,Pg:487
                                                      
  end Ex12_12_b;
  //===============================
  //The temperature at the exit can be read directly from the chart. The result is T2 = 23.5 deg C
end Ex12_12;
