/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_15 Page:500
//Title:Determining Mass Flow Rates for a Power Plant Cooling Tower
//===============================
model Ex12_15

    //parameter selection
    parameter Real m1(unit="kg/h")=4.5e7"mass flow rate of water into cooling tower";
    parameter Real p(unit="bar")=1.01325"total pressure";
    parameter Real phi3(unit="-")=0.35"relative humidity of inlet air";
    parameter Real phi4(unit="-")=0.90"relative humidity of exit air";
    parameter Real pg3(unit="bar")=0.03169"saturation pressure for inlet";
                                                          /*From Table A-2 at T=25 C. 
                                                          Appendix Pg:A-3*/
    parameter Real pg4(unit="bar")=0.05628"saturation pressure for exit";
                                                          /*From Table A-2 at T=35 C. 
                                                          Appendix Pg:A-3*/
    parameter Real hf1(unit="kJ/kg")=159.21"specific enthalpy of saturated liquid at inlet";
    parameter Real hg3(unit="kJ/kg")=2547.2"saturation vapour enthalpy at inlet";
                                                          /*From Table A-2 at T=38 C. 
                                                          Appendix Pg:A-3*/
    parameter Real hf2(unit="kJ/kg")=125.79"specific enthalpy of saturated liquid at exit";
    parameter Real hg4(unit="kJ/kg")=2565.3"saturation vapour enthalpy at exit";
                                                          /*From Table A-2 at T=30 C. 
                                                          Appendix Pg:A-3*/
    parameter Real ha3(unit="kJ/kg")=298.2"specific enthalpy of dry air at inlet";      
                                                          /*From Table A-22 at T=298 K. 
                                                          Appendix Pg:A-39*/
    parameter Real ha4(unit="kJ/kg")=308.2"specific enthalpy of dry air at exit";      
                                                          /*From Table A-22 at T=308 K. 
                                                          Appendix Pg:A-39*/
    parameter Real hf5(unit="kJ/kg")=83.96 "specific enthalpy of makeup water";
                                                          /*From Table A-2 at T=20 C. 
                                                          Appendix Pg:A-3*/    
    //===============================
    
    //variable selection
    Real omega3(unit="-")"humidity ratio for inlet air";
    Real omega4(unit="-")"humidity ratio for exit air";
    Real pv3(unit="bar")"partial pressure of water vapour at inlet";
    Real pv4(unit="bar")"partial pressure of water vapour at exit";
    Real m2(unit="kg/h")"mass flow rate of water from cooling tower";
    Real m5(unit="kg/h")"mass flow rate of makeup water";
    Real mv3(unit="kg/h")"mass flow rate of inlet air";
    Real mv4(unit="kg/h")"mass flow rate of exit air";
    Real ma(unit="kg/h")"mass flow rate of dry air";
    //===============================
    
    //equation selection
    equation
      omega3=0.622*pv3/(p-pv3);
      omega4=0.622*pv4/(p-pv4);                               //From Eq.12.43, Pg:476
      phi3=pv3/pg3;
      phi4=pv4/pg4;                                           //Relative humidity
      m1=m2;
      m5=ma*(omega4-omega3);
      mv3=omega3*ma;
      mv4=omega4*ma;                                          //Humidity ratio
      0=m1*hf1+ma*ha3+mv3*hg3+m5*hf5-m2*hf2-(ma*ha4+mv4*hg4); //Reduced energy rate balance

end Ex12_15;
//===============================
