/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_5 Page:470
//Title:Investigating Adiabatic Mixing of Gases at Constant Total Volume
//===============================
package Ex12_5
  model Ex12_5_a
  //To find final temperature of the mixture
  
      //parameter selection
      parameter Real nN2(unit = "lbmol") = 0.79 "moles of nitrogen";
      parameter Real nO2(unit = "lbmol") = 0.21 "moles of oxygen";
      parameter Real T_N2(unit = "R") = 460 "initial temperature of nitrogen";
      parameter Real T_O2(unit = "R") = 540 "initial temperature of oxygen";
      parameter Real cv_N2(unit = "Btu/lb.R") = 0.177 "constant volume specific heat of nitrogen"; 
                                                                      //On molecular weight basis
      parameter Real cv_O2(unit = "Btu/lb.R") = 0.156 "constant volume specific heat of oxygen";
                                                                      //On molecular weight basis
      final constant Real M_N2(final unit = "lb/lbmol") = 28.01 "molecular weight of nitrogen";
      final constant Real M_O2(final unit = "lb/lbmol") = 32.0 "molecular weight of oxygen";
                                                                      /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real T2(unit = "R") "final temperature of the mixture";
      Real cvm_N2(unit = "Btu/lbmol.R") "specific heat constant of nitrogen on molar basis";
      Real cvm_O2(unit = "Btu/lbmol.R") "specific heat constant oxygen on molar basis";
      //===============================
      
      //equation selection
      equation
        cvm_N2 = M_N2 * cv_N2;
        cvm_O2 = M_O2 * cv_O2;
        0 = nN2 * cvm_N2 * (T2 - T_N2) + nO2 * cvm_O2 * (T2 - T_O2);   //Reduced closed system energy balance
  end Ex12_5_a;
  //===============================

  model Ex12_5_b
  //To find the final pressure of the mixture
  
      //===============================
      extends Ex12_5_a;
      //===============================
      
      //parameter selection
      parameter Real pN2(unit="atm")=2"initial pressure of nitrogen";
      parameter Real pO2(unit="atm")=1"initial pressure of oxygen";
      //===============================
      
      //variable selection
      Real p2(unit="atm")"final pressure of the mixture";
      //===============================
      
      //equation selection
      equation
        p2=(nN2+nO2)*T2/(nN2*T_N2/pN2+nO2*T_O2/pO2);    //From ideal gas equation of state
  end Ex12_5_b;
  //===============================

  model Ex12_5_c
  //To find amount of entropy produced
  
      //===============================
      extends Ex12_5_a;
      extends Ex12_5_b;
      //===============================
      
      //parameter selection
      final constant Real R(final unit="Btu/lb-mol.R")=1.986"gas constant";
      //===============================
      
      //variable selection
      Real cp_N2(unit="Btu/lbmol.R")"constant pressure specific heat of nitrogen";
      Real cp_O2(unit="Btu/lbmol.R")"constant pressure specific heat of oxygen";
      Real sigma(unit="Btu/R")"amount of entropy produced";
      Real yN2(unit="-")"mole fraction of nitrogen";
      Real yO2(unit="-")"mole fraction of oxygen";
      //===============================
      
      //equation selection
      equation
        cp_N2=cvm_N2+R;
        cp_O2=cvm_O2+R;               //specific heats relation
        yN2=nN2/(nN2+nO2);
        yO2=nO2/(nN2+nO2);
        sigma=nN2*(cp_N2*log(T2/T_N2)-R*log(yN2*p2/pN2))+nO2*(cp_O2*log(T2/T_O2)-R*log(yO2*p2/pO2));     
                                      //Closed system form of entropy balance and From Eq.12.34, Pg:466
      
  end Ex12_5_c;
  //===============================
end Ex12_5;
