/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_7 Page:479
//Title:Cooling Moist Air at Constant Pressure
//===============================
package Ex12_7
  model Ex12_7_a
  //To find initial humidity ratio
  
      //parameter selection
      parameter Real p(unit = "lbf/in2") = 14.7 "total pressure";
      parameter Real phi(unit = "-") = 0.7 "relative humidity";
      parameter Real pg1(unit = "lbf/in2") = 0.3632 "saturation pressure at state 1";    
                                                              /*From Table A-23 at T=70 F. 
                                                              Appendix Pg:A-51*/
      //===============================
      
      //variable selection
      Real omega(unit = "lb(vapour)/lb(dry air)") "humidity ratio";
      Real pv1(unit = "lbf/in2") "partial pressure of water vapour";
      //===============================
      
      //equation selection
      equation
        pv1 = phi * pg1;                  //Partial pressure 
        omega = 0.622 * pv1 / (p - pv1);  //From Eq.12.43, Pg:476
  end Ex12_7_a;
  //===============================

  model Ex12_7_b
  //To find dew point temperature
  
    //===============================
    extends Ex12_7_a;
    //===============================
    
    //parameter selection
    parameter Real Ta(unit="F")=58"temperature a";
    parameter Real Tb(unit="F")=60"temperature b";
    parameter Real pva(unit="lbf/in2")=0.2386"partial pressure a";
    parameter Real pvb(unit="lbf/in2")=0.2563"partial pressure b";
                                        /*From Table A-2E corresponding to 
                                        partial pressure pv1=0.2542 lbf/in^2. 
                                        Appendix Pg:A-51*/
    //===============================
    
    //variable selection
    Real T(unit="F")"dew point temperature";
    //===============================
    
    //equation selection
    equation
      (T-Ta)/(Tb-Ta)=(pv1-pva)/(pvb-pva);     //Interpolation

  end Ex12_7_b;
  //===============================

  model Ex12_7_c
  //To find amount of water vapour condenses
  
      //===============================
      extends Ex12_7_a;
      //===============================
      
      //parameter selection
      parameter Real mi(unit="lb")=1"initial amount of dry air";
      parameter Real  pg2(unit="lbf/in2")=0.1217"saturation  pressure at state 2";   
                                                              /*From Table A-23 at T=40 F. 
                                                              Appendix Pg:A-51*/
      //===============================
      
      //variable selection
      Real mw(unit="lb")"amount of condensate";
      Real mv1(unit="lb")"initial amount of water vapour in sample";
      Real ma(unit="lb")"mass of dry air";
      Real mv2(unit="lb")"final amount of water vapor";
      Real omega2(unit="lb(vapour)/lb(dry air)")"final humidity ratio";
      //===============================
      
      //equation selection
      equation
        mi=ma+mv1;
        omega2=0.622*pg2/(p-pg2);     //From Eq.12.43, Pg:476
        ma=mv1/omega;
        mv2=omega2*ma;                //From Eq.12.42, Pg:475
        mw=mv1-mv2;
  end Ex12_7_c;
  //===============================
end Ex12_7;
