/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_8 Page:480
//Title:Cooling Moist Air at Constant Volume
//===============================
package Ex12_8
  model Ex12_8_a
    //To find dew point temperature
    
    //parameter selection
    parameter Real phi(unit = "-") = 0.10 "relative humidity";
    parameter Real pg1(unit = "bar") = 1.985 "saturation pressure at state 1";
                                                        /*From Table A-2 at T=120 C. 
                                                        Appendix Pg:A-4*/
    parameter Real Ta(unit = "C") = 55 "temperature a";
    parameter Real Tb(unit = "C") = 60 "temperature b";
    parameter Real pva(unit = "bar") = 0.1576 "partial pressure a";
    parameter Real pvb(unit = "bar") = 0.1994 "partial pressure b";
                                                        /*From Table A-2 corresponding to 
                                                        partial pressure pv1=0.1985 bar. 
                                                        Appendix Pg:A-4*/
    //===============================
    
    //variable selection
    Real pv1(unit = "bar") "partial pressure of water vapour";
    Real T(unit = "C") "dew point temperature";
    //===============================
    
    //equation selection
    equation
    pv1 = phi * pg1;                                    //Partial pressure
    (T - Ta) / (Tb - Ta) = (pv1 - pva) / (pvb - pva);   //Interpolation
  end Ex12_8_a;

  //===============================

  model Ex12_8_b
  //To find temperature when condensation begins
  
      //===============================
      extends Ex12_8_a;
      //===============================
      
      //parameter selection
      parameter Real T1(unit="C")=120"initial temperature";
      parameter Real T2a(unit="F")=55"temperature a";
      parameter Real T2b(unit="F")=60"temperature b";
      parameter Real vVa(unit="m3/kg")=9.568"specific volume a";
      parameter Real vVb(unit="m3/kg")=7.671"specific volume b";
                                                    /*From Table A-2 corresponding to 
                                                    partial pressure vV1=9.145 m3/kg. 
                                                    Appendix Pg:A-4*/      
      final constant Real R(final unit="J/kmol.K")=8314"gas constant";
      final constant Real Mv(final unit="kg/kmol")=18.02"molecular mass of water"; 
                                                    /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real vV1(unit="m3/kg")"specific volume of the vapour at state 1";
      Real T2(unit="C")"dew point temperature";
      //===============================
      
      //equation selection
      equation
        vV1=R/Mv*(T1+273.15)/(pv1*10^5);        //Ideal gas equation of state
                                                //Adding 273.15 to convert into Kelvin scale
                                                //Multiplying 10^5 to convert into Pa
        (T2-T2a)/(T2b-T2a)=(vV1-vVa)/(vVb-vVa); //Interpolation
  end Ex12_8_b;

  //===============================

  model Ex12_8_c
    //To find amount of water condensed
    
    //===============================
    extends Ex12_8_a;
    extends Ex12_8_b;
    //===============================
    
    //parameter selection
    parameter Real V(unit = "m3") = 35 "volume of the closed vessel";
    parameter Real vV2(unit = "m3/kg") = 9.145 " final specific volume of liquid-vapour mixture";
    parameter Real vf2(unit = "m3/kg") = 1.0022e-3 "final specific volume of saturated liquid";
    parameter Real vg2(unit = "m3/kg") = 51.447 "final specific volume of saturated vapour";
                                                            /*From Table A-2 at T=22 C. 
                                                            Appendix Pg:A-3*/
    //===============================
    
    //variable selection
    Real mV1(unit = "kg") "mass of water vapour present";
    Real x2(unit = "-") "quality of liquid-vapour mixture";
    Real mV2(unit = "kg") "water vapor contained in the system at the final state";
    Real mW2(unit = "kg") "mass of the condensate";
    //===============================
    
    //equation selection
    equation
    mV1 = V / vV1;
    x2 = (vV2 - vf2) / (vg2 - vf2);     //Quality of liquid-vapour mixture
    mV2 = x2 * mV1;
    mW2 = mV1 - mV2;
  end Ex12_8_c;

  //===============================
end Ex12_8;
