/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-12,Ideal Gas Mixture and Psychrometric Applications
//Example 12_9 Page:481
//Title:Evaluating Heat Transfer for Moist Air Cooling at Constant Volume
//===============================
model Ex12_9

    //parameter selection
    parameter Real V(unit="m3")=35"volume of the closed vessel";
    parameter Real p(unit="bar")=1.5"total pressure";
    parameter Real T1(unit="C")=120"initial temperature";
    parameter Real phi(unit="-")=0.10"relative humidity";
    parameter Real T2(unit="C")=22"final temperature";
    parameter Real pv1(unit="bar")=0.1985"saturation pressure at state 1";
    parameter Real ua1(unit="kJ/kg")=281.1"specific internal energy of air at state 1";   
                                                              /*From Table A-22 at T=393 K. 
                                                              Appendix Pg:A-39*/
    parameter Real ua2(unit="kJ/kg")=210.49"specific internal energy of air at state 2";   
                                                              /*From Table A-22 at T=295 K. 
                                                              Appendix Pg:A-39*/
    parameter Real ug2(unit="kJ/kg")=2405.7"specific internal energy of saturated vapour at state 2";   
                                                              /*From Table A-2 at T=22 C. 
                                                              Appendix Pg:A-3*/
    parameter Real uf2(unit="kJ/kg")=92.32"specific internal energy of liquid water at state 2";   
                                                              /*From Table A-2 at T=22 C. 
                                                              Appendix Pg:A-3*/
    parameter Real ug1(unit="kJ/kg")=2529.3"specific internal enery of saturated vapour at state 1";   
                                                              /*From Table A-2 at T=120 C. 
                                                              Appendix Pg:A-4*/
    parameter Real mv2(unit="kg")=0.681"mass of saturated vapour at state 2";
    parameter Real mv1(unit="kg")=3.827"mass of saturated vapour at state 1";
    parameter Real mw2(unit="kg")=3.146"mass of saturated liquid at state 2";      
                                                              /*From solution to Example 12.8. 
                                                              Pg:480*/
    final constant Real R(final unit="J/kmol.K")=8314"gas constant";
    final constant Real Ma(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                              /*From Table A-1. Appendix Pg:A-2*/
    //===============================
    
    //variable selection                                                
    Real Q(unit="kJ")"heat transfer during the process";
    Real ma(unit="kg")"mass of dry air";
    Real pa1(unit="bar")"partial pressure of air";
    //===============================
    
    //equation selection
    equation
      Q=ma*(ua2-ua1)+mv2*ug2+mw2*uf2-mv1*ug1;     //Reduced closed system energy balance
      ma=pa1*10^5*V/(R/Ma*(T1+273.15));           //Ideal gas equation of state 
                                                  //Adding 273.15 to convert into Kelvin scale
                                                  //Multiplying 10^5 to convert into Pa
      pa1=p-pv1;                                  //Partial pressure of air

end Ex12_9;
//===============================
