/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_1 Page:507
//Title:Determining the Air–Fuel Ratio for Complete Combustion of Octane
//===============================
package Ex13_1
  model Ex13_1_a
  //To find theoretical amount of air
  
      //parameter selection
      parameter Real n_O2(unit = "mole") = 1 "moles of oxygen in air";
      parameter Real n_N2(unit = "mole") = 3.76 "moles of nitrogen in air";
      parameter Real n_f(unit = "kmol") = 1 "moles of fuel";
      parameter Real Mf(unit = "kg/kmol") = 114.22 "molecular mass of fuel";
      final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
      //===============================
      
      //variable selection 
      Real a(unit = "-") "stoichiometric coefficient for O in chemical equation";
      Real b(unit = "-") "stoichiometric coefficient for C in chemical equation";
      Real c(unit = "-") "stoichiometric coefficient for H in chemical equation";
      Real d(unit = "-") "stoichiometric coefficient for N in chemical equation";
      Real AF(unit = "kmol(air)/kmol(fuel)") "air-fuel ratio on molar basis";
      Real AFm(unit = "kg(air)/kg(fuel)") "air-fuel ratio on mass basis";
      //===============================
      
      //equation selection
      equation
        b = 8;
        2 * c = 18;
        2 * b + c = 2 * a;
        d = n_N2 * a;                     //For chemical equation C8H18+a(O2+3.76N2)-> bCO2+cH2O+dN2
        AF = (a + a * n_N2) / n_f;        //Air-fuel ratio
        AFm = AF * Ma / Mf;               //From Eq.13.2, Pg:506

  end Ex13_1_a;
  //===============================

  model Ex13_1_b
  //To find air-fuel ratio for 150% theoretical air
  
      //parameter selection
      parameter Real n_O2(unit = "mole") = 1 "moles of oxygen in air";
      parameter Real n_N2(unit = "mole") = 3.76 "moles of nitrogen in air";
      parameter Real n_f(unit = "kmol") = 1 "moles of fuel";
      parameter Real e_air(unit="-")=1.5"theoretical excess air";
      parameter Real Mf(unit = "kg/kmol") = 114.22 "molecular mass of fuel";
      parameter Real a(unit = "-")=12.5 "stoichiometric coefficient for chemical equation";
                                                                       /*From solution to part (a)*/
      final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
      //===============================
      
      //variable selection
      Real b(unit = "-") "stoichiometric coefficient for C in chemical equation";
      Real c(unit = "-") "stoichiometric coefficient for H in chemical equation";
      Real d(unit = "-") "stoichiometric coefficient for N in chemical equation";
      Real e(unit = "-") "stoichiometric coefficient for O in chemical equation";
      Real AF(unit = "kmol(air)/kmol(fuel)") "air-fuel ratio on molar basis";
      Real AFm(unit = "kg(air)/kg(fuel)") "air-fuel ratio on mass basis";
      //===============================
      
      //equation selection
      equation
        b = 8;
        2 * c = 18;
        2 * b + c + 2 * e = e_air * a * 2;
        d = n_N2 * e_air * a ;            
        AF = e_air*(a + a * n_N2) / n_f;   //Air-fuel ratio
        AFm = AF * Ma / Mf;                //From Eq.13.2, Pg:506
    
  end Ex13_1_b;
  //===============================
end Ex13_1;
