/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_10 Page:534
//Title:Determine Entropy Change for Combustion of Gaseous Methane with Oxygen at Constant Volume
//===============================
model Ex13_10

    //parameter selection
    parameter Real pref(unit="atm")=1"initial pressure";
    parameter Real p2(unit="atm")=3.02"final pressure";
                                            /*From solution to Example 13.6, Pg:519*/
    parameter Real sCO2(unit="kJ/kmol.K")=263.559"absolute specific entropy of CO2";
                                            /*From Table A-23 for CO2 at T=900 K. 
                                            Appendix Pg:A-42*/
    parameter Real sH2O(unit="kJ/kmol.K")=228.321"absolute specific entropy of H2O";
                                            /*From Table A-23 for H2O at T=900 K. 
                                            Appendix Pg:A-42*/
    parameter Real sO2(unit="kJ/kmol.K")=205.03"absolute specific entropy of O2";
                                            /*From Table A-23 for O2 at T=289 K. 
                                            Appendix Pg:A-41*/
    parameter Real sCH4(unit="kJ/kmol.K")=186.16"absolute specific entropy of CH4";
                                            /*From Table A-23 for CH4 at T=289 K. 
                                            Appendix Pg:A-41*/
    parameter Real nCH4(unit="kmol")=1"moles of CH4";
    parameter Real nO2(unit="kmol")=2"moles of O2";
    parameter Real nCO2(unit="kmol")=1"moles of CO2";
    parameter Real nH2O(unit="kmol")=2"moles of H2O";
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real SP(unit="kJ/K")"final entropy of the system";
    Real SR(unit="kJ/K")"initial entropy of the system";
    Real sCH4_Tr(unit="kJ/kmol.K")"specific entropy of CH4 at initial state";
    Real sO2_Tr(unit="kJ/kmol.K")"specific entropy of O2 at initial state";
    Real sCO2_T2(unit="kJ/kmol.K")"specific entropy of CO2 at final state";
    Real sH2O_T2(unit="kJ/kmol.K")"specific entropy of H2O at final state";
    Real yCH4(unit="-")"mole fraction of CH4";
    Real yO2(unit="-")"mole fraction of O2";
    Real yCO2(unit="-")"mole fraction of CO2";
    Real yH2O(unit="-")"mole fraction of H2O";
    Real del_S(unit="kJ/K")"change in entropy";
    //===============================
    
    //equation selection
    equation
      SR=nCH4*sCH4_Tr+nO2*sO2_Tr;
      SP=nCO2*sCO2_T2+nH2O*sH2O_T2;
      yCH4=nCH4/(nO2+nCH4);
      yO2=nO2/(nO2+nCH4);
      yCO2=nCO2/(nCO2+nH2O);
      yH2O=nH2O/(nCO2+nH2O);                    //Mole fraction
      sCH4_Tr=sCH4-R*log(yCH4*pref/pref);
      sO2_Tr=sO2-R*log(yO2*pref/pref);
      sCO2_T2=sCO2-R*log(yCO2*p2/pref);
      sH2O_T2=sH2O-R*log(yH2O*p2/pref);         //From Eq.13.23, Pg:531
      del_S=SP-SR;

end Ex13_10;
//===============================
