/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_11 Page:535
//Title:Determining the Gibbs Function of Formation for Methane
//===============================
model Ex13_11
    
    //parameter selection
    parameter Real gR(unit="kJ/kmol")=0"gibbs function of formation for carbon and hydrogen";            
                                                /*From Table A-25 for carbon and hydrogen. 
                                                Appendix Pg:A-46*/
    parameter Real hf_CH4(unit="kJ/kmol")=-74850"enthalpy of formation of CH4";
    parameter Real sCH4(unit="kJ/kmol.K")=186.16"absolute  entropy of CH4";
                                                /*From Table A-25 for CH4. 
                                                Appendix Pg:A-46*/
    parameter Real sC(unit="kJ/kmol.K")=5.74"absolute entropy of C";            
                                                /*From Table A-25 for carbon. 
                                                Appendix Pg:A-46*/
    parameter Real sH2(unit="kJ/kmol.K")=130.57"absolute entropy of H2";
                                                /*From Table A-25 for hydrogen. 
                                                Appendix Pg:A-46*/
    parameter Real Tref(unit="C")=25"temperature of the standard state";
    //===============================
    
    //variable selection
    Real del_g(unit="kJ/kmol")"change in Gibbs function of formation";
    //===============================
    
    //equation selection
    equation
    
      del_g=hf_CH4-(Tref+273.15)*(sCH4-sC-2*sH2)-gR;     //From Eq.13.28(b), Pg:535
                                                         //Adding 273.15 to convert into Kelvin scale
end Ex13_11;
//===============================
