/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_14 Page:546
//Title:Evaluating the Total Flow Exergy of Fuel Entering a Combustor
//===============================
model Ex13_14

  //parameter selection
  parameter Real m(unit="kg/s")=1.64"mass flow rate of methane";
  parameter Real T0(unit="K")=298.15"dead state temperature";
  parameter Real p0(unit="bar")=1.01325"pressure at state 0";
  parameter Real p10(unit="bar")=12"pressure at state 10";                                         
  parameter Real e_ch(unit="kJ/kmol")=831650 "molar chemical exergy of methane";              
                                                                    /*From Table A-26 Model-II for methane. 
                                                                    Appendix Pg:A-47*/
  
  final constant Real M(unit="kg/kmol")=16.04"molecular mass of methane";
  final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
  //===============================
  
  //variable selection
  Real ef(unit="kJ/kg")"total flow exergy";
  Real E10(unit="MW")"total flow exergy rate";
  //===============================
  
  //equation selection
  equation
    ef=R/M*T0*log(p10/p0)+e_ch/M;      //From Eq.13.47, Pg:545
    E10=m*(ef)*(1/10^3);               //Dividing by MW to convert into MW
end Ex13_14;
