/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_16 Page:550
//Title:Evaluating Exergetic Efficiency of an Internal Combustion Engine
//===============================
model Ex13_16

    //parameter selection
    parameter Real Wcv(unit="hp")=50"power output";
    parameter Real mF(unit="lb/s")=0.004"mass flow rate of fuel";
                                                        /*From Example 13.4, Pg:516*/
    parameter Real Mf(unit="lb/lbmol")=114.22"molecular weight of fuel";     
                                                        /*From Table A-1E for octane. 
                                                        Appendix Pg:A-50*/
    parameter Real e_ch(unit="kJ/kmol")=5413100"molar chemical exergy";
                                                        /*From Table A-26 Model II for octane. 
                                                        Appendix Pg:A-47*/
    //===============================
     
    //variable selection
    Real EF(unit="Btu/s")"exergy entering rate";
    Real epsilon(unit="-")"exergetic efficiency";  
    //===============================
  
    //equation selection
    equation
      EF=mF*e_ch/Mf*(1/2.326);         //Total flow exergy on time-rate basis
                                       //Dividing by2.326 to convert into Btu/lb
      epsilon=Wcv/EF*2545/3600;        //Exergetic efficiency
                                       //Multiplying by 2545 to convert into Btu/h
                                       //Dividing by 3600 to convert into h     
end Ex13_16;
//===============================
