/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_17 Page:551
//Title:Evaluating Exergetic Efficiency of a Reactor Fueled by Liquid Octane
//===============================
model Ex13_17

    //parameter selection
    parameter Real T0(unit="K")=298"temperature of the environment";
    parameter Real sigmacv_nFa(unit="kJ/kmol.K")=5404"rate of entropy production for theoretical amount of air";
    parameter Real sigmacv_nFb(unit="kJ/kmol.K")=9754"rate of entropy production for 400% excess air";
                                                                  /*From solution to Example 13.9, Pg:532*/
    parameter Real EF(unit="kJ/kmol")=5413100"molar chemical exergy of fuel";
                                                                  /*From Table A-26 Model II for octane. 
                                                                  Appendix Pg:A-47*/
    //===============================
    
    //variable selection
    Real Ed_nFa(unit="kJ/kmol")"exergy destruction for theoretical amount of air";
    Real Ed_nFb(unit="kJ/kmol")"exergy destruction for 400% excess air";
    Real epsilona(unit="-")"exergetic efficiency for theoretical amount of air";
    Real epsilonb(unit="-")"exergetic efficiency for 400% excess air";
    //===============================
    
    //equation selection
    equation
      Ed_nFa=T0*sigmacv_nFa;
      Ed_nFb=T0*sigmacv_nFb;            //Exergy destruction
      epsilona=1-Ed_nFa/EF;
      epsilonb=1-Ed_nFb/EF;             //Exergetic efficiency

end Ex13_17;
//===============================
