/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_3 Page:510
//Title:Burning Natural Gas with Excess Air
//===============================
package Ex13_3
  model Ex13_3_a
  //To find air-fuel ratio
  
    //parameter selection
    parameter Real n_O2(unit = "mole") = 1 "moles of oxygen in air";
    parameter Real n_N2(unit = "mole") = 3.76 "moles of nitrogen in air";
    parameter Real n_f(unit = "kmol") = 1 "moles of fuel";
    parameter Real CH4_p(unit = "%") = 80.62 "percent of CH4 in natural gas";
    parameter Real C2H6_p(unit = "%") = 5.41 "percent of C2H6 in natural gas";
    parameter Real C3H8_p(unit = "%") = 1.87 "percent of C3K8 in natural gas";
    parameter Real C4H10_p(unit = "%") = 1.60 "percent of C4H10 in natural gas";
    parameter Real CO2_p(unit = "%") = 7.8 "percent of CO2 in product";
    parameter Real CO_p(unit = "%") = 0.2 "percent of CO in product";
    parameter Real O2_p(unit = "%") = 7 "percent of O2 in product";
    parameter Real N2_p(unit = "%") = 85 "percent of N2 in product";
    final constant Real Ma(final unit = "kg/kmol") = 28.97 "molecular mass of air";
    final constant Real MCH4(final unit = "kg/kmol") = 16.04 "molecular mass of methane";
    //===============================
    
    //variable selection
    Real a(unit = "-") "stoichiometric coefficient for O in chemical equation";
    Real b(unit = "-") "stoichiometric coefficient for C in chemical equation";
    Real c(unit = "-") "stoichiometric coefficient for H in chemical equation";
    Real AF(unit = "kmol(air)/kmol(fuel)") "air-fuel ratio on molar basis";
    //===============================
    
    //equation selection
    equation
      b * (CO2_p + CO_p) = CH4_p + 2 * C2H6_p + 3 * C3H8_p + 4 * C4H10_p;
      2 * c = 4 * CH4_p * 0.01 + 6 * C2H6_p * 0.01 + 8 * C3H8_p * 0.01 + 10 * C4H10_p * 0.01;
      b * (2 * CO2_p * 0.01 + CO_p * 0.01 + 2 * O2_p * 0.01) + c = 2 * a;
                                            //Chemical equation balance
      AF = (a + a * n_N2) / n_f;            //Air-fuel ratio

  end Ex13_3_a;
  //===============================

  model Ex13_3_b
  //To find amount of product
  
    //===============================
    extends Ex13_3_a;
    //===============================
    
    //parameter selection
    parameter Real V(unit="m3")=100"volume of fuel mixture";
    parameter Real p(unit="bar")=1"pressure of fuel mixture";
    parameter Real T(unit="K")=300"temperature of fuel mixture";
    final constant Real R(final unit="J/kmol.K")=8314"gas constant";
    //===============================
    
    //variable selection
    Real nF(unit="kmol")"amount of fuel";
    Real prdct(unit="kmol")"amount of product mixture";
    //===============================
    
    //equation selection
    equation
      nF=p*10^5*V/(R*T);        //Ideal gas equation of state
                                //Multiplying by 10^5 to convert into Pa
      prdct=(b+c)*nF;
  end Ex13_3_b;
  //===============================

  model Ex13_3_c
  //To find percent theoretical air
  
    //===============================
    extends Ex13_3_a;
    //===============================
    
    //variable selection
    Real AFtheo(unit="kmol(air)/kmol(fuel)")"theoretical air–fuel ratio";
    Real percent_air(unit="%")"percent theoretical air";
    //===============================
    
    //equation selection
    equation
      AFtheo=2*(n_O2+n_N2)/n_f;       //Air–fuel ratio
      percent_air=AF/AFtheo*100;      //Percent theoretical air
      
  end Ex13_3_c;
  //===============================
end Ex13_3;
