/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_4 Page:516
//Title:Analyzing an Internal Combustion Engine Fueled with Liquid Octane
//===============================
model Ex13_4

    //parameter selection
    parameter Real Wcv(unit="hp")=50"power output";
    parameter Real Mf(unit="lb/lbmol")=114.22"molecular weight of fuel";     
                                                                /*From Table A-1E for octane. 
                                                                Appendix Pg:A-50*/
    parameter Real mf(unit="lb/s")=0.004"mass flow rate of fuel";
    parameter Real hR(unit="Btu/lbmol(fuel)")=-107530"specific enthalpy of formation for C8H18";    
                                                                /*From Table A-25E for C8H18. 
                                                                Appendix Pg:A-96*/
    parameter Real hCO2(unit="Btu/lbmol")=-169300"specific enthalpy of formation for CO2";         
                                                                /*From Table A-25E for CO2. 
                                                                Appendix Pg:A-96*/
    parameter Real hCO2_1(unit="Btu/lbmol")=4027.5"specific enthalpy of CO2 at state 1";     
                                                                /*From table A-23E at T=537 R. 
                                                                Appendix Pg:A-91*/
    parameter Real hCO2_2(unit="Btu/lbmol")=15829"specific enthalpy of CO2 at state 2";       
                                                                /*From table A-23E at T=1600 R. 
                                                                Appendix Pg:A-92*/
    parameter Real hH2O(unit="Btu/lbmol")=-104040"specific enthalpy of formation for H2O";       
                                                                /*From Table A-25E for H2O. 
                                                                Appendix Pg:A-96*/
    parameter Real hH2O_1(unit="Btu/lbmol")=4258"specific enthalpy of H2O at state 1";
                                                                /*From table A-23E at T=537 R. 
                                                                Appendix Pg:A-91*/
    parameter Real hH2O_2(unit="Btu/lbmol")=13494.4"specific enthalpy of H2O at state 2";
                                                                /*From table A-23E at T=1600 R. 
                                                                Appendix Pg:A-92*/
    
    parameter Real hN2_1(unit="Btu/lbmol")=3729.5"specific enthalpy of CO2 at state 1";    
                                                                /*From table A-23E at T=537 R. 
                                                                Appendix Pg:A-91*/
    parameter Real hN2_2(unit="Btu/lbmol")=11409.7"specific enthalpy of CO2 at state 2";
                                                                /*From table A-23E at T=1600 R. 
                                                                Appendix Pg:A-92*/
    parameter Real nCO2(unit="-")=8"stoichiometric coefficient of CO2 in product";
    parameter Real nO2(unit="-")=9"stoichiometric coefficient of O2 in product";
    parameter Real nN2(unit="-")=47"stoichiometric coefficient of N2 in product";
    //===============================
    
    //variable selection
    Real hP(unit="Btu/lbmol(fuel)")"net specific enthalpy for formation and state 1 and 2";
    Real Qcv(unit="Btu/s")"heat transfer rate";
    Real nF(unit="lbmol(fuel)/s")"molar flow rate of fuel";
    //===============================
    
    //equation selection
    equation
    hP=nCO2*(hCO2+hCO2_2-hCO2_1)+nO2*(hH2O+hH2O_2-hH2O_1)+nN2*(hN2_2-hN2_1);  //From Eq.13.9, Pg:513
    nF=mf/Mf;                                                       //Molar flow rate
    Qcv=Wcv*2545/3600+nF*(hP-hR);                                   //Reduced energy rate balance
                                                                    //Multiplying by 2545 to convert into Btu/h
                                                                    //Dividing by 3600 to convert into per s

end Ex13_4;
//===============================
