/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_6 Page:519
//Title:Analyzing Combustion of Methane with Oxygen at Constant Volume
//===============================
package Ex13_6
  model Ex13_6_a
  //To find amount of heat transfer
  
    //parameter selection
    parameter Real T1(unit = "K") = 298 "temperature at state 1";
    parameter Real T2(unit = "K") = 900 "temperature at state 2";
    parameter Real hCH4(unit = "kJ/kmol(fuel)") = -74850 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for CH4. 
                                                                      Appendix Pg:A-46*/
    parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
    parameter Real hCO2_1(unit = "kJ/kmol") = 9364 "specific enthalpy of CO2 at state 1";
                                                                      /*From table A-23 at T=298 K. 
                                                                      Appendix Pg:A-41*/
    parameter Real hCO2_2(unit = "kJ/kmol") = 37405 "specific enthalpy of CO2 at state 2";
                                                                      /*From table A-23 at T=900 K. 
                                                                      Appendix Pg:A-42*/
    parameter Real hH2O(unit = "kJ/kmol") = -241820 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
    parameter Real hH2O_1(unit = "kJ/kmol") = 9904 "specific enthalpy of H2O at state 1";
                                                                      /*From table A-23 at T=298 K. 
                                                                      Appendix Pg:A-41*/
    parameter Real hH2O_2(unit = "kJ/kmol") = 31828 "specific enthalpy of H2O at state 2";
                                                                      /*From table A-23 at T=900 K. 
                                                                      Appendix Pg:A-42*/
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    //===============================
    
    //variable selection
    Real Q(unit = "kJ") "heat transfer";
    //===============================
    
    //equation selection
    equation
      Q = hCO2 + hCO2_2 - hCO2_1 + 2 * (hH2O + hH2O_2 - hH2O_1) - hCH4 + 3 * R * (T1 - T2);      
                                                                      //Reduced energy balance
  end Ex13_6_a;
  //===============================

  model Ex13_6_b
  //To find final pressure
    
    //===============================
    extends Ex13_6_a;
    //===============================
    
    //parameter selection
    parameter Real p1(unit="atm")=1"initial pressure";
    //===============================
    
    //variable selection 
    Real p2(unit="atm")"final pressure";
    //===============================
    
    //equation selection
    equation
      p2=T2/T1*p1;       //Pressure-temperature relationship
    
  end Ex13_6_b;
  //===============================
end Ex13_6;
