/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-13,Reacting Mixtures and Combustion
//Example 13_8 Page:524
//Title:Determining the Adiabatic Flame Temperature for Complete Combustion of Liquid Octane
//===============================
package Ex13_8
  model Ex13_8_a
  //To find temperature and combustion product with theoretical amount of air
    
    //parameter selection
    parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
    parameter Real hH2O(unit = "kJ/kmol") = -241820 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
    parameter Real hC8H18(unit = "kJ/kmol") = -249910 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for C8H18. 
                                                                      Appendix Pg:A-46*/                                                                  
  
    parameter Real hN2(unit = "kJ/kmol") = 0 "specific enthalpy of formation for N2";
                                                                      /*From Table A-25 for N2. 
                                                                      Appendix Pg:A-46*/                                                                  
    parameter Real hO2(unit = "kJ/kmol") = 0 "specific enthalpy of formation for O2";
                                                                      /*From Table A-25 for O2. 
                                                                      Appendix Pg:A-46*/                                                                  
    parameter Real nCO2(unit="-")=8"stoichiometric coefficient of CO2 in product";
    parameter Real nH2O(unit="-")=9"stoichiometric coefficient of H2O in product";
    parameter Real nN2(unit="-")=47"stoichiometric coefficient of N2 in product";
    parameter Real hPa(unit="kJ/kmol")=4955163"enthalpy of CO2 at product temperature a";
    parameter Real hPb(unit="kJ/kmol")=5089337"enthalpy of H2O at product temperature a";
    parameter Real Ta(unit="K")=2350"temperature a";
    parameter Real Tb(unit="K")=2400"temperature b";
                                          /*From Table in Example 13.8, Pg:524*/ 
    //===============================
    
    //variable selection
    Real hf(unit="kJ/kmol(fuel)")"specific enthalpy change";
    Real T(unit="K")"temperature of the combustion products"; 
    
    //===============================
    
    //equation selection
    equation 
      hf=hC8H18+hO2+nN2*hN2-(nCO2*hCO2+nH2O*hH2O+nN2*hN2);        //Reduced energy balance equation
      (T-Ta)/(Tb-Ta)=(hf-hPa)/(hPb-hPa);                          //Interpolation
      
  end Ex13_8_a;
  //===============================

  model Ex13_8_b
  //To find temperature and combustion product with 400% excess amount of air
    
    //parameter selection
     parameter Real hCO2(unit = "kJ/kmol") = -393520 "specific enthalpy of formation for CO2";
                                                                      /*From Table A-25 for CO2. 
                                                                      Appendix Pg:A-46*/
     parameter Real hH2O(unit = "kJ/kmol") = -241820 "specific enthalpy of formation for H2O";
                                                                      /*From Table A-25 for H2O. 
                                                                      Appendix Pg:A-46*/
     parameter Real hC8H18(unit = "kJ/kmol") = -249910 "specific enthalpy of formation for C8H18";
                                                                      /*From Table A-25 for C8H18. 
                                                                      Appendix Pg:A-46*/                                                                    
     parameter Real hN2(unit = "kJ/kmol") = 0 "specific enthalpy of formation for N2";
                                                                      /*From Table A-25 for N2. 
                                                                      Appendix Pg:A-46*/                                                                  
     parameter Real hO2(unit = "kJ/kmol") = 0 "specific enthalpy of formation for O2";
                                                                      /*From Table A-25 for O2. 
                                                                      Appendix Pg:A-46*/                                                                  
     parameter Real nCO2(unit="-")=8"stoichiometric coefficient of CO2 in product";
     parameter Real nH2O(unit="-")=9"stoichiometric coefficient of H2O in product";
     parameter Real nN2(unit="-")=188"stoichiometric coefficient of N2 in product";
     parameter Real nO2(unit="-")=37.5"stoichiometric coefficient of O2 in product";
                                                                      /*From Table in Example 13.8, Pg:524*/ 
    //===============================
    
    //variable selection
    Real hfe(unit="kJ/kmol(fuel)")"specific enthalpy change for excess air";
  
    
    //equation selection
    equation
      hfe=hC8H18+50*hO2+188*hN2-(nCO2*hCO2+nH2O*hH2O+nO2*hO2+nN2*hN2);        //Reduced energy balance equation
    
  /*Similar to solution to part (a) the temperature of the products is found to be TP = 962 K.*/
  end Ex13_8_b;
  //===============================
end Ex13_8;
