/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_4 Page:567
//Title:Considering the Effect on Equilibrium of an Inert Component
//===============================
model Ex14_4
  
  //parameter selection
  parameter Real pref(unit = "atm") = 1 "reference pressure";
  parameter Real p(unit = "atm") = 1 "mixture pressure";
  parameter Real K(unit = "-") = 0.0363 "equilibrium constant";      
                                    /*From Table A-27 value of K at T=2500 K. 
                                    Appendix Pg:A-48*/
  //===============================
  
  //variable selection
  Real n(unit = "moles") "total moles in mixture";
  Real z(unit = "-") "stoichiometric coefficient";
  Real yCO(unit = "-") "mole fraction of CO";
  Real yCO2(unit = "-") "mole fraction of CO2";
  Real yO2(unit = "-") "mole fraction of O2";
  Real yN2(unit = "-") "mole fraction of N2";
  
  //===============================
  
  //equation selection
  equation
    n = (5.76 +z ) / 2;                                                     //Total number of moles
    K = z / (1 - z) * (z /( 5.76 + z ) ) ^ (1 / 2) * (p / pref) ^ (1 / 2);  //Equilibrium constant
                                                                            //From Eq.14.35, Pg:565
    yCO = z / n;
    yCO2 = (1 - z) / n;
    yN2 = 1.88 / n;
    yO2 = z / 2 / n;                                                        //Mole fraction

end Ex14_4;
