/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_9 Page:578
//Title:Considering Equilibrium with Simultaneous Reactions
//===============================
model Ex14_9

    //parameter selection
    parameter Real K1(unit="-")=-0.3273"equilibrium constant value for first reaction";
                                                    /*From Table A-27 at T=3000 K 
                                                    value of K for CO2 reaction. 
                                                    Appendix Pg:A-48*/
    parameter Real K2(unit="-")=0.1222"equilibrium constant value for second reaction";
                                                    /*From Table A-27 at T=3000 K 
                                                    value of K for O2+N2 reaction. 
                                                    Appendix Pg:A-48*/
    //===============================
    
    //variable selection
    Real a(unit="-")"unknown for the balanced equation";
    Real b(unit="-")"unknown for the balanced equation";
    Real yCO(unit = "-") "equilibrium composition of CO";
    Real yCO2(unit = "-") "equilibrium composition of CO2";
    Real yO2(unit = "-") "equilibrium composition of O2";
    Real yN2(unit = "-") "equilibrium composition of N2";
    Real yNO(unit = "-") "equilibrium composition of NO";
    //===============================
    
    //equation selection  
    equation
    K1=a/(a-1)*((1+a-b)/(4+a))^0.5;
    K2=2*b/((1+a-b)*(1-b))^0.5;           //Equilibrium constant
                                          //From Eq.14.35, Pg:565
    yCO=a;
    yNO=b;
    yCO2=1-a;
    yO2=(1+a-b)/2;
    yN2=(1-b)/2;                          //Composition of mixture from reaction equation
    
end Ex14_9;
//===============================
