/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-2 Energy and the First Law of Thermodynamics
//Example 2_1 Page:33
//Title:Evaluating expansion work
//===============================
package Ex2_1
//===============================
  model Ex2_1_a
 //To find work for the process when n=1.5
    //===============================
    
    //parameter selection
    parameter Real p1(unit = "bar") = 3 "Inital pressure";
    parameter Real v1(unit = "m3") = 0.1 "Initial volume";
    parameter Real v2(unit = "m3") = 0.2 "Final volume";
    parameter Real n(unit ="-") = 1.5 "Constant for polytropic process";
    //===============================
    
    //variable selection
    Real p2(unit = "bar") "Final pressure";
    Real Wa(unit = "kJ") "Work for n=1.5";
    //===============================
    
    //equation selection
    equation
      p1 * v1 ^ n = p2 * v2 ^ n;                              //Pressure-Volume relationship
      Wa = (p2 * v2 - p1 * v1) / (1 - n) * (10 ^ 5 / 10 ^ 3); //Work expression for polytropic process
                                                              //Multiplying by 10^5 to convert into Pa
                                                              //Dividing by 10^3 to convert into kJ
  end Ex2_1_a;
  //===============================

 
  model Ex2_1_b
  //To find work for the process when n=1
  
    //=============================
    extends Ex2_1_a;
    //=============================
    
    //variable selection
    Real Wb(unit = "kJ")"Work for n=1";
    
    //equation selection
    equation
      Wb = p1 * v1 * log(v2 / v1) * (10 ^ 5 / 10 ^ 3);  //Work expression for n=1
                                                        //Multiplying by 10^5 to convert into Pa
                                                        //Dividing by 10^3 to convert into kJ
  end Ex2_1_b;
  //===============================

  model Ex2_1_c
  //To find work for process when n=0
  
    //===============================
    extends Ex2_1_a;
    //===============================
    
    //variable selection
    Real Wc(unit = "kJ")"Work when n=0";
    
    //===============================
    //equation selection
    equation
    Wc = p1 * (v2 - v1) * (10 ^ 5 / 10 ^ 3);  //Work expression for n=0 
                                              //Multiplying by 10^5 to convert into Pa
                                              //Dividing by 10^3 to convert into kJ
    
  end Ex2_1_c;
  //===============================
end Ex2_1;
//===============================
