/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-2 Energy and the First Law of Thermodynamics
//Example 2_3 Page:46
//Title:Considering Alternative Systems
//===============================
package Ex2_3
  model Ex2_3_a
  //Heat transfer of the system considering air alone
  
    //parameter selection
    parameter Real mp(unit = "lb") = 100 "Mass of piston";
    parameter Real ma(unit = "lb") = 0.6 "Mass of air";
    parameter Real patm(unit = "lbf/in2") = 14.7 "Atmospheric pressure";
    parameter Real a(unit = "ft2") = 1 "Area of piston";
    parameter Real g(unit = "ft/s2") = 32 "Accleration due to gravity";
    parameter Real dv(unit = "ft3") = 1.6 "Change in volume";
    parameter Real du(unit = "Btu/lb") = 18 "Change in specific internal energy";
    //===============================
    
    //variable selection
    Real Qa(unit = "Btu") "Heat transfer";
    Real p(unit = "lbf/in2") "Total pressure";
    Real Wa(unit = "Btu") "Work";
    //===============================
    
    //equation selection
    equation
      p = mp * g / a / (32.2 * 144) + patm;  //Dividing by (32.2*144) to convert into lbf/in^2
      Wa = p * dv * (144 / 778);             // Work expression
                                             //Multiplying by (144/778) to convert to Btu
      Qa = Wa + ma * du;                     //Energy balance equation
  end Ex2_3_a;

  //==================================

  model Ex2_3_b
  //Heat transfer of the system considering air and piston
    
    //==================================
    extends Ex2_3_a;
    //===============================
    
    //variable selection
    Real Qb(unit = "Btu") "Heat transfer";
    Real Wb(unit = "Btu") "Work";
    Real dz(unit = "ft") "Elevation of the piston";
    Real dPE(unit = "Btu") "Change in potential energy of piston";
    //===============================
    
    //equation selection
    equation
      dz = dv / a;  //Elevation change
      dPE = mp * g * dz / (32.2*778);   //Potential energy change
                                        //Dividing by (32.2*778) to convert into Btu
      Wb = patm * dv * (144/ 778);      //Work expression
                                        //Multiplying by (144/778) to convert into Btu
      Qb = Wb + ma * du + dPE;       
  end Ex2_3_b;

  //===============================
end Ex2_3;
