/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-2 Energy and the First Law of Thermodynamics
//Example 2_6 Page:49
//Title:Transient Operation of a Motor
//===============================
model Ex2_6

  //parameter selection
  parameter Real w(unit="rad/s")=100"Angular velocity";
  parameter Real tor(unit="N.m")=18"Torque";
  parameter Real We(unit="kW")=-2"Electrical power input";
  //===============================
  
  //===============================
    annotation(experiment(StartTime = 0, StopTime =120));  //Time range selction for graph
  //===============================
  
  //variable selection
  Real Q(unit="kW")"Heat transfer rate";
  Real E(unit="kJ")"Internal energy";
  Real Ws(unit="kW")"Shaft power output";
  Real W(unit="kW")"Net power";
  //===============================
  
  //equation selection
  equation
    Ws=tor*w/(10^3);                //Shaft power
                                    //Dividing by 10^3 to convert into kW
    Q=-0.2*(1-exp(-0.05 * time));   //Energy rate balance
    W=We+Ws;                        //Net power
    der(E)=Q-W;

end Ex2_6;
//The final answer is plotted as graph
//===============================
