/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_12 Page:101
//Title:Analyzing Polytropic Processes of Air as an Ideal Gas
//===============================
package Ex3_12
  model Ex3_12_a
  //To find work and heat transfer for n=1.3
  
      //parameter selection
      parameter Real p1(unit = "atm") = 1 "initial pressure";
      parameter Real T1(unit = "F") = 70 "initial temperature";
      parameter Real p2(unit = "atm") = 5 "final pressure";
      parameter Real n(unit = "-") = 1.3 "polytropic constant";
      parameter Real k(unit = "-") = 1.401 "constant specific heat ratio";             
                                                    /*From Table A-20E for T=70 F. 
                                                    Appendix Pg:A-87*/
      final constant Real R(final unit = "Btu/lb-mol.R") = 1.986 "gas constant";
      final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
      //===============================
      
      //variable selection
      Real W1(unit = "Btu/lb") "work per unit mass";
      Real Q1(unit = "Btu/lb") "heat transfer per unit mass";
      Real T2(unit = "F") "final temperature";
      Real cv(unit = "Btu/lb.R") "specific heat at state 1";
      //===============================
      
      //equation selection
      equation
        W1 = R / M * (T2 - T1) / (1 - n);       //Work for polytropic process
        Q1 = W1 + cv * (T2 - T1);               //Heat transfer from energy balance
        T2 + 459.67 = (T1 + 459.67) * (p2 / p1) ^ ((n - 1) / n);
                                                //Adding 459.67 to convert into Rankein scale
        cv = R / M / (k - 1);                   //From 3.47(b). Pg:93
    end Ex3_12_a;

  //===============================

  model Ex3_12_b
  //To find work and heat transfer for n=k
  
      //===============================
      extends Ex3_12_a;
      //===============================
      
      //variable selection
      Real W2(unit = "Btu/lb") "work per unit mass";
      Real Q2(unit = "Btu/lb") "heat transfer per unit mass";
      //===============================
      
      //equation selection
      equation
        W2 = R / M * (T2 - T1) / (1 - k);     //Work for polytropic process
        Q2 = W2 + R/M*(T2 - T1)/(k - 1);      //Heat transfer from energy balance
  end Ex3_12_b;

  //===============================
end Ex3_12;
