/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_6 Page:84
//Title:Measuring the calorie value of cooking oil
//===============================
model Ex3_6

    //parameter selection
    parameter Real Mw(unit="kg")=2.15"mass of water bath";
    parameter Real Ma(unit="kg")=0.5"equivalent mass of apparatus";
    parameter Real T1(unit="C")=25"initial temperature";
    parameter Real T2(unit="C")=25.3"final teperature";
    parameter Real Cw(unit="kJ/kg.K")=4.18"specific heat of water";      
                                                      /*From Table A-19.Appendix Pg:A-36*/
    //===============================
    
    //variable selection
    Real dU(unit="kJ")"change in internal energy";
    Real dU1(unit="kcal/mL")"change in internal energy per mL";
    Real dU2(unit="kcal/mL")"change in internal energy per tablespoon";
    //===============================
    
    //equation selection
    equation
    dU=-(Mw+Ma)*Cw*(T2-T1);        //Change in internal energy equation
    dU1=dU/(0.1*4.1868);           //Dividing by (0.1*4.1868) to convert into kcal/mL
    dU2=dU1*15;                    //A tablespoon is approximated as 15mL

end Ex3_6;
 //===============================
