/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_1 Page:109
//Title:Applying the Mass Rate Balance to a Feedwater Heater at Steady State
//===============================
model Ex4_1

    //parameter selection
    parameter Real p1(unit="bar")=7"water vapour pressure at inlet 1";
    parameter Real T1(unit="C")=200"water vapour temperature at inlet 1";
    parameter Real m1(unit="kg/s")=40"mass flow rate at inlet 1";
    parameter Real p2(unit="bar")=7"liquid water pressure at inlet 2";
    parameter Real T2(unit="C")=40"liquid water temperature at inlet 2";
    parameter Real A2(unit="cm2")=25"cross sectional area at inlet 2";
    parameter Real p3(unit="bar")=7"saturated liquid pressure at exit";
    parameter Real AV3(unit="m3/s")=0.06"volumetric flow rate at exit";
    parameter Real v3(unit="m3/kg")=1.108e-3"specific volume at the exit";             
                                                            /*From Table A-3 at P=7 bar.
                                                            Appendix Pg:A-5*/
    parameter Real v2(unit="m3/kg")=1.0078e-3"specific volume of liquid at inlet 2";   
                                                            /*From Table A-2 at T=40 C.                                                                  
                                                            Appendix Pg:A-3*/
    //===============================
                                                                                       
    //variable selection                                                                                                                                                                      
    Real m2(unit="kg/s")"mass flow rate at inlet 2";
    Real m3(unit="kg/s")"mass flow rate at the exit";
    Real V2(unit="m/s")"velocity at inlet 2";
    //===============================
    
    //equation selection
    equation
    
    m3=AV3/v3;            //Mass flow rate 
    m2=m3-m1;             //Mass rate balance equation
    V2=m2*v2/A2*10^4;     //Velocity 
                          //Multiplying by 10^4 to convert m^2 to cm^2
end Ex4_1;
//===============================
