/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_10 Page:133
//Title:Evaluating Performance of a Waste Heat Recovery System
//===============================
package Ex4_10
  model Ex4_10_a
    //To determine the power developed by the turbine
    
    //parameter selection
    parameter Real p1(unit = "atm") = 1 "combustion product inlet pressure";
    parameter Real T1(unit = "F") = 400 "combustion product inlet temperature";
    parameter Real AV1(unit = "ft3/min") = 2e5 "flow rate of combustion product ";
    parameter Real m3(unit = "lb/min") = 275 "mass flow rate of water";
    parameter Real x5(unit = "-") = 0.93 "exit water vapour quality";
    parameter Real h1(unit = "Btu/lb") = 206.46 "specific enthalpy of combustion product at state 1";
                                                           /*From Table A-22E at T=860 R. Appendix Pg:A-89*/
    parameter Real h2(unit = "Btu/lb") = 172.39 "specific enthalpy of combustion product at state 2";
                                                           /*From Table A-22E at T=720 R. Appendix Pg:A-89*/
    parameter Real h3(unit = "Btu/lb") = 70.0 "specific enthalpy of water at state 3";
                                                           /*From Table A-2E by interpolating T=100 F and T=110 F
                                                           values to T=102 F. Appendix Pg:A-51*/
    parameter Real hg5(unit = "Btu/lb") = 1105.74 "specific enthalpy of saturated vapour at state 5";
    parameter Real hf5(unit = "Btu/lb") = 69.74 "specific enthalpy of saturated liquid at state 5";
                                                           /*From Table A-3E at P=1 lbf/in^2. Appendix Pg:A-53*/
    final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real Wcv(unit = "Btu/min") "power developed by the turbine";
    Real m1(unit = "lb/min") "combustion product mass flow rate";
    Real v1(unit = "ft3/lb") "specific volume at state 1";
    Real h5(unit = "Btu/lb") "specific enthalpy at state 5";
    //===============================
    
    //equation selection
    equation
    h5 = hf5 + x5 * (hg5 - hf5);
    m1 = AV1 / v1;
    v1 = R * (T1 + 459.67) / (M * p1 * 14.7 * 144);  //Ideal gas equation
                                                     //Adding 459.67 to convert in Rankein scale
                                                     //Multiplying 14.7 to convert into lbf/in^2
                                                     //Multiplying 144 to convert into in^2
    Wcv = m1 * (h1 - h2) + m3 * (h3 - h5);           //Energy rate balance equation
  end Ex4_10_a;

  //===============================

  model Ex4_10_b
    //To find the turbine inlet temperature in F
    
    //===============================
    extends Ex4_10_a;
    //===============================
    
    //parameter selection
    parameter Real ha(unit = "Btu/lb")=1211.8 "specific enthalpy a";
    parameter Real hb(unit = "Btu/lb")=1236.4 "specific enthalpy b";
    parameter Real Ta(unit = "F")=350"temperature a";
    parameter Real Tb(unit = "F")=400"temperature b";
                                              /*From Table A-4E at P=40 lbf/in^2 with h4.
                                              Appendix Pg:A-55*/
    //===============================
    
    //variable selection
    Real h4(unit = "Btu/lb") "specific enthalpy at state 4";
    Real T4(unit = "F") "turbine inlet temperature";
    //===============================
    
    //equation selection
    equation
     h4 = h3 + m1 / m3 * (h1 - h2);
     (T4-Ta)/(Tb-Ta)=(h4-ha)/(hb-ha);       //Interpolation
    
  end Ex4_10_b;

  //===============================

  model Ex4_10_c
  //To determine the cost of operation
  
    //===============================
    extends Ex4_10_a;
    //===============================
    
    //parameter selection
    parameter Real cost(unit="$/kW.h")=0.115"cost per kW.h";
    parameter Real hours(unit="h/year")=8000"annual operational hours";
    //===============================
    
    //variable selection
    Real annual_value(unit="$/year")"annual operational costs";
    //===============================
    
    //equation selection
    equation
     annual_value=Wcv*cost*hours*60/3413;   //Multiplying by 60 to convert into minute
                                            //Dividing by 3413 to convert into kW
  
  end Ex4_10_c;

  //===============================
end Ex4_10;
//===============================





