/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_12 Page:138
//Title:Using Steam for Emergency Power Generation
//===============================
model Ex4_12

    //parameter selection
    parameter Real V(unit="m3")=0.6"volume of the tank";
    parameter Real v2(unit="m3/kg")=0.203"specific volume of steam";
    parameter Real u2(unit="kJ/kg")=2951.3"specific internal energy of steam";    /*From Table A-4 at 
                                                                                  P=15 bar and T=400 C. 
                                                                                  Appendix Pg:A-8*/
    parameter Real hi(unit="kJ/kg")=3081.9"specific enthalpy of steam entering"; /*From Table A-4 
                                                                                  at P=15 bar and T=320 C.
                                                                                 Appendix Pg:A-8*/
    //===============================
    
    //variable selection
    Real m2(unit="kg")"mass within the tank";
    Real Wcv(unit="kJ")"work developed by turbine";
    //===============================
    
    //equation selection
    equation
    m2=V/v2;
    Wcv=m2*(hi-u2);   //From Ex 4.12 equation (a). Pg:138
end Ex4_12;
//===============================
