/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_4 Page:121
//Title:Calculating Heat Transfer from a Steam Turbine
//===============================
model Ex4_4

    //parameter selection
    parameter Real m1(unit="kg/h")=4600"inlet mass flow rate";
    parameter Real p1(unit="bar")=60"inlet steam pressure";
    parameter Real T1(unit="C")=400"inlet steam temperature";
    parameter Real V1(unit="m/s")=10"inlet steam velocity";
    parameter Real Wcv(unit="kW")=1000"turbine power output";
    parameter Real p2(unit="bar")=0.1"exit steam pressure";
    parameter Real V2(unit="m/s")=30"exit steam velocity";
    parameter Real x2(unit="-")=0.9"exit vapour quality";
    parameter Real h1(unit="kJ/kg")=3177.2"specific enthalpy at inlet";                
                                                        /*From Table A-4 at P=60 bar 
                                                        and T=400 C. Appendix Pg:A-9*/                                                                            
    parameter Real hg2(unit="kJ/kg")=2584.63"specific enthalpy of saturated vapour";   
                                                        /*From Table A-3 at P=0.1 bar. 
                                                        Appendix Pg:A-5*/
    parameter Real hf2(unit="kJ/kg")=191.83"specific enthalpy of saturated liquid";    
                                                        /*From Table A-3 at P=0.1 bar. 
                                                        Appendix Pg:A-5*/
    //===============================
    
    //variable selection
    Real Qcv(unit="kW")"heat transfer rate";
    Real h2(unit="kJ/kg")"specific enthalpy at exit";
    //===============================
    
    //equation selection
    equation
    h2=hf2+x2*(hg2-hf2);                                       
    0=Qcv-Wcv+(m1*((h1-h2)+((V1^2-V2^2)/2)/10^3))/3600;        //Steady-state energy rate balance equation
                                                               //Dividing by 10^3 to convert bar into Pa
                                                               //Dividing by 3600 to convert hr into s
end Ex4_4;
//===============================
