/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_7 Page:128
//Title:Evaluating Performance of a Power Plant Condenser
//===============================
package Ex4_7
  model Ex4_7_a
    //To find the ratio of mass flow rate
    
    //parameter selection
    parameter Real hf1(unit = "kJ/kg") = 191.83 "specific enthalpy of saturated liquid at state 1";
    parameter Real hg1(unit = "kJ/kg") = 2584.7 "specific enthalpy of saturated vapour at state 1";
                                                                            /*From Table A-3 for P=0.1 bar. 
                                                                            Appendix Pg:A-5*/                                                                                                                  
    parameter Real h2(unit = "kJ/kg") = 188.45 "specific enthalpy at state 2";                    
                                                                            /*From Table A-2 for T=45 C.
                                                                            Appendix Pg:A-3*/              
    parameter Real h3(unit = "kJ/kg") = 83.96 "specific enthalpy at state 3";                      
                                                                            /*From Table A-2 for T=20 C.                      
                                                                            Appendix Pg:A-3*/
    parameter Real h4(unit = "kJ/kg") = 146.68 "specific enthalpy at state 4";                    
                                                                            /*From Table A-2 for T=35 C.
                                                                            Appendix Pg:A-3*/                                                                                                                 
    parameter Real x(unit = "-") = 0.95 "quality of steam at state 1";
    //===============================
    
    //variable selection
    Real h1(unit = "kJ/kg") "specific enthalpy at state 1";
    Real ratio(unit = "-") "ratio of mass flow rates";        //Ratio= m3/m1
                                                              // m3/m1=(h1-h2)/(h4-h3)
                                                              /*Where m3 is the mass flow rate 
                                                              of cooling water and m1 is the mass
                                                              flow rate of steam*/
    //===============================
    
    //equation selection
    equation
      h1 = hf1 + x * (hg1 - hf1);           //Specific enthalpy for liquid-vapour mixture
      ratio = (h1 - h2) / (h4 - h3);        //From Ex 4.7, Pg:128
   end Ex4_7_a;
  //===============================

  model Ex4_7_b
  //To find the energy transfer from condensing steam to cooling water per kg of steam
  
    //===============================
    extends Ex4_7_a;
    //===============================
    
    //variable selection
    Real Qm1(unit="kJ/kg")"mass specific energy transfer";
    //===============================
    
    //equation selection
    equation
      Qm1=h2-h1;   //From Ex 4.7, Pg:129
    
  end Ex4_7_b;
  //===============================
end Ex4_7;
