/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_9 Page:131
//Title:Measuring Steam Quality
//===============================
model Ex4_9
    
    //parameter selection
    parameter Real h2(unit="Btu/lb")=1168.8"specific enthalpy at state 2";                   
                                                            /*From Table A-4E at
                                                            P=14.7lbf/in^2 and T=250 F.
                                                            Appendix Pg:A-55*/
    parameter Real hf1(unit="Btu/lb")=394.1"specific enthalpy of saturated liquid at state 1";
    parameter Real hg1(unit="Btu/lb")=1203.9"specific enthalpy of saturated vapour at state 1";   
                                                            /*From Table A-3E at 
                                                            P=300 lbf/in^2 . 
                                                            Appendix Pg:A-54*/
    //===============================
    
    //variable selection
    Real x(unit = "-")"quality of vapour at state 1";
    Real h1(unit="Btu/lb")"specific enthalpy at state 1";
    //===============================
    
    //equation selection
    equation
    h1=h2;               //Throttling process
    h1=hf1+x*(hg1-hf1);  //Vapour quality for liquid-vapour mixture

end Ex4_9;
//===============================
