/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-5,The second law of thermodynamics
//Example 5_2 Page:169
//Title:Evaluating refrigerator performance
  model Ex5_2
  //===============================
  
  //parameter selection
  parameter Real Qc(unit="kJ/h")=8000"Heat transfer rate";
  parameter Real W(unit="kJ/h")=3200"Power required";
  parameter Real Tc(unit="C")=-5"Temperature of the freezer";
  parameter Real Th(unit="C")=22"Temperature of the surrounding";
  //===============================
  
  //variable selection  
  Real b(unit="-")"Coefficient of performance for given operating condition";
  Real bmax(unit="-")"Maximum Coefficient of performance";
  //===============================
  
  //equation selection
  equation
  b=Qc/W;                                     //Coefficient of performance
  bmax=(Tc+273.15)/((Th+273.15)-(Tc+273.15)); //Maximum Coefficient of performance
                                              //Adding 273.15 to convert into Kelvin scale
  if b<bmax then
   Modelica.Utilities.Streams.print("irreversibilities are present within the system"); 
  end if;
  end Ex5_2;
 //===============================
