/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_1 Page:189
//Title:Evaluating Work and Heat Transfer for an Internally Reversible Process of Water
//===============================
model Ex6_1

    //parameter selection
    parameter Real T(unit="C")=150"initial temperature";
    parameter Real v1(unit="m3/kg")=1.0905e-3"specific volume of saturated liquid";
    parameter Real v2(unit="m3/kg")=0.3928"specific volume of saturated vapour";
    parameter Real s1(unit="kJ/kg.K")=1.8418"specific entropy of saturated liquid";
    parameter Real s2(unit="kJ/kg.K")=6.8379"specific entropy of saturated vapour";
    parameter Real p(unit="bar")=4.758"saturation pressure"; 
                                                         /*From Table A-2 fot T=150 C.
                                                         Appendix Pg:A-4*/
    //===============================
    
    //varibale selection
    Real W(unit="kJ/kg")"work per unit mass";
    Real Q(unit="kJ/kg")"heat transfer per unit mass";
    //===============================
    
    //equation selection    
    equation
      W=p*(v2-v1)*(10^5/10^3);    //Constant pressure work
                                  //Multiplying by 10^5 to convert into Pa
                                  //Dividing by 10^3 to convert into kJ
      Q=(T+273.15)*(s2-s1);       //Heat transfer
                                  //Adding 273.15 to convert into Kelvin scale

end Ex6_1;
//===============================
