/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_10 Page:211
//Title:Considering Air Leaking from a Tank
//===============================
model Ex6_10

    //parameter selection
    parameter Real p1(unit="bar")=5"initial pressure";
    parameter Real p2(unit="bar")=1"final pressure";
    parameter Real T1(unit="K")=500"initial temperature";
    parameter Real m1(unit="kg")=5"initial mass of air in tank";
    parameter Real pr1(unit = "-")=8.411 "relative pressure at state 1";      
                                                                 /*From table A-22 at T=500 K.
                                                                 Appendix Pg:A-39*/
    parameter Real Ta(unit="K")=315"temperature a";
    parameter Real Tb(unit="K")=320"temperature b";
    parameter Real pra(unit="-")=1.6442"relative pressure a";
    parameter Real prb(unit="-")=1.7375"relative pressure b";
                                                                 /*From Table A-22 by for 
                                                                 interpolating T value of pr=1.6822.                                                              
                                                                 Appendix Pg:A-39*/    
    //===============================
    
    //variable selection
    Real pr2(unit = "-")"relative pressure at state 2";
    Real m2(unit="kg")"remaining mass of air";
    Real T2(unit="K")"final temperature";
    //===============================
    
    //equation selection
    equation
      pr2/pr1=p2/p1;                        //From Eq 6.41, Pg:208
      (T2-Ta)/(Tb-Ta)=(pr2-pra)/(prb-pra);  //Interpolation
      m2=(p2/p1)*(T1/T2)*m1;                //From Ex 6.10, Pg:211

end Ex6_10;
//===============================
