/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_13 Page:215
//Title:Evaluating Isentropic Nozzle Efficiency
//===============================
model Ex6_13

    //parameter selection
    parameter Real V1(unit="ft/s")=100"inlet velocity";
    parameter Real h1(unit="Btu/lb")=1326.4"specific enthalpy at inlet";   
                                                                       /*From Table A-4E at T=600 F 
                                                                       and P=140 lbf/in^2. 
                                                                       Appendix Pg:A-56*/
    parameter Real h2(unit="Btu/lb")=1211.8"specific enthalpy at exit";
                                                                       /*From Table A-4E at T=350 F 
                                                                       and P=40 lbf/in^2. 
                                                                       Appendix Pg:A-55*/
    parameter Real h2s(unit="Btu/lb")=1202.3"specific enthaply after isentropic expansion"; 
                                                                       /*Interpolating in Table A-4E at 
                                                                       40 lbf/in2, with s=1.7191 Btu/lb.R. 
                                                                       Appendix Pg:A-55*/
    //===============================
    
    //variable selection
    Real V2(unit="ft/s")"exit velocity";
    Real V2s(unit="ft/s")"exit velocity after isentropic expansion";
    Real KE2(unit="Btu/lb")"specific kinetic energy at the exit";
    Real KE2s(unit="Btu/lb")"specific kinetic energy at the exit of isentropic expansion";
    Real nNozzle(unit="-")"nozzle efficiency";
    //===============================
    
    //equation selection
    equation
      V2^2/2=h1-h2+V1^2/(2*32.2*778);
      V2s^2/2=h1-h2s+V1^2/(2*32.2*778);       //Energy balance equation
                                              //Dividing by 32.2*778 to convert into Btu/lb
      KE2=V2^2/2;
      KE2s=V2s^2/2;
      nNozzle=(KE2)/(KE2s);                   //From Eq 6.47, Pg:215

end Ex6_13;
//===============================
