/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_5 Page:197
//Title:Quenching a Hot Metal Bar
//===============================
package Ex6_5

  model Ex6_5_a
  //To find final equilibrium temperature
    
      //parameter selection
      parameter Real mm(unit = "lb") = 0.8 "mass of metal bar";
      parameter Real mw(unit = "lb") = 20 "mass of water";
      parameter Real Tmi(unit = "R") = 1900 "initial temperature of metal bar";
      parameter Real Twi(unit = "R") = 530 "initial temperature of water";
      parameter Real cw(unit = "Btu/lb") = 1.0 "specific heat of water";
      parameter Real cm(unit = "Btu/lb") = 0.1 "specific heat of metal bar";
      //===============================
      
      //variable selection
      Real Tf(unit = "R") "final equilibrium temperature";
      //===============================
      
      //equation selection
      equation
        mw * cw * (Tf - Twi) + mm * cm * (Tf - Tmi) = 0;    //Energy balance
        
  end Ex6_5_a;
  //===============================

  model Ex6_5_b
  //To find amount of entropy produced
  
      //===============================
      extends Ex6_5_a;
      extends Modelica.Math;
      //===============================
      
      //variable selection
      Real sigma(unit="Btu/R")"amount of entropy produced";
      //===============================
      
      //equation selection
      equation
        sigma=mw*cw*log(Tf/Twi)+mm*cm*log(Tf/Tmi);   //Entropy balance
      
    end Ex6_5_b;
    //=============================== 
end Ex6_5;
/*The  answer may slightly vary due to  rounding off values
Variable name           Book value        Obtained value
sigma                   0.0864            0.103596       */

