/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_6 Page:203
//Title:Determining Entropy Production in a Steam Turbine
//===============================
model Ex6_6

  //parameter selection
  parameter Real V1(unit="m/s")=160"inlet velocity";
  parameter Real V2(unit="m/s")=100"exit velocity";
  parameter Real Wcv(unit="kJ/kg")=540"work developed by turbine per kg of steam";
  parameter Real Tb(unit="K")=350"outer surface temperature";
  parameter Real h1(unit="kJ/kg")=3230.9"specific enthalpy at inlet";    /*From Table A-4 at 
                                                                         P=30 bar and T=400 C.
                                                                         Appendix Pg:A-8*/
  parameter Real h2(unit="kJ/kg")=2676.1"specific enthalpy at exit";     /*From Table A-2 at 
                                                                         T=100 C for saturated vapour. 
                                                                         Appendix Pg:A-4*/
  parameter Real s1(unit="kJ/kg.K")=6.9212"specific entropy at inlet";   /*From Table A-4 at 
                                                                         P=30 bar and T=400 C. 
                                                                         Appendix Pg:A-8*/
  parameter Real s2(unit="kJ/kg.K")=7.3549"specific entropy at exit";    /*From Table A-2 
                                                                         at T=100 C for saturated vapour. 
                                                                         Appendix Pg:A-4*/
  //===============================
  
  //varaible selection
  Real Qcv(unit="kJ/kg")"heat transfer rate per kg of steam";
  Real sigma(unit="kJ/kg.K")"entropy production rate per kg of steam";
  
  //===============================
  
  //equation selection
  equation
    sigma=-Qcv/Tb+(s2-s1);                  //Reduced mass and energy rate balance
    Qcv=Wcv+(h2-h1)+(V2^2-V1^2)/(2*10^3);   //Entropy rate balance
                                            //Dividing by 10^3 to convert to kJ

end Ex6_6;
//===============================
