/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_7 Page:204
//Title:Evaluating a Performance Claim
//===============================
model Ex6_7

    //===============================
    extends Modelica.Math;
    //===============================
    
    //parameter selection
    parameter Real p1(unit="atm")=5.1"inlet pressure";
    parameter Real T1(unit="F")=70"inlet temperature";
    parameter Real p2(unit="atm")=1"hot oulet pressure";
    parameter Real T2(unit="F")=175"hot outlet temperature";
    parameter Real p3(unit="atm")=1"cold outlet pressure";
    parameter Real T3(unit="F")=0"cold outlet temperature";
    final constant Real cp(final unit = "Btu/lb.R") = 0.24 "specific heat constant of air";  
                                                                      /*From Table A-20E. 
                                                                      Appendix Pg:A-87*/
    final constant Real R(final unit = "Btu/lb-mol.R") = 1.9858 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
    //===============================
     
    //variable selection
    Real sigma(unit="Btu/lb.R")"entropy production rate per unit mass";
    String mass_balance;
    Real x(unit="-")"check for mass balance";             //To check for mass balance        
    //===============================
    
    //equation selection
    equation
     x=0.4*(T1-T2)+0.6*(T1-T3);           //From Ex6.7, Pg:204
      
      if x == 0 then
        mass_balance="mass balance satisfied";
      else 
        mass_balance="mass balance is not satisfied";
      end if;
      
     Modelica.Utilities.Streams.print(mass_balance);  
     
     sigma=0.4*(cp*log((T2+459.67)/(T1+459.67))-R/M*log(p2/p1))+0.6*(cp*log((T3+459.67)/(T1+459.67))-R/M*log(p3/p1));
                                              //From Eq 6.22, Pg:186
                                              //Adding 459.67 to convert into Rankein scale
    if sigma > 0 then
      Modelica.Utilities.Streams.print("inventor’s claim does not violate principles of thermodynamics"); 
    end if; 
end Ex6_7;
//===============================
