/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_8 Page:205
//Title:Determining Entropy Production in Heat Pump Components
//===============================
package Ex6_8
  model Ex6_8_a
    //To find entropy production rates
    
    //parameter selection
    parameter Real p5(unit = "bar") = 1 "pressure of air at state 5";
    parameter Real T5(unit = "C") = 20 "temperature of air at state 5";
    parameter Real AV5(unit = "m3/s") = 0.42 "flow rate of air";
    parameter Real p6(unit = "bar") = 1 "pressure of air at state 6";
    parameter Real T6(unit = "C") = 50 "temperature of air at state 6";
    parameter Real s1(unit = "kJ/kg.K") = 0.9572 "specific entropy of refrigerant at state 1";
                                                                                /*From Table A-9 
                                                                                at P=3.5 bar and T=-5 C. 
                                                                                Appendix Pg:A-16*/
    parameter Real h2(unit = "kJ/kg") = 294.17 "specific enthalpy of refrigerant at state 2";
    parameter Real s2(unit = "kJ/kg.K") = 0.98225 "specific entropy of refrigerant at state 2";
                                                                                /*From Table A-9 
                                                                                at P=14 bar and T=75 C. 
                                                                                Appendix Pg:A-18*/
    parameter Real h3(unit = "kJ/kg") = 79.05 "specific enthalpy of refrigerant at state 3";
    parameter Real s3(unit = "kJ/kg.K") = 0.2936 "specific entropy of refrigerant at state 3";
                                                                                /*From Table A-7 
                                                                                at T=28 C. 
                                                                                Appendix Pg:A-13*/
    parameter Real hf4(unit = "kJ/kg") = 33.09 "specific enthalpy of saturated liquid at state 4";
    parameter Real hfg4(unit = "kJ/kg") = 212.91 "specific enthalpy difference at state 4";
    parameter Real sf4(unit = "kJ/kg.K") = 0.1328 "specific entropy of saturated liquid at state 4";
    parameter Real sg4(unit = "kJ/kg.K") = 0.9431 "specific entropy of saturated vapour at state 4";
                                                                                /*From Table A-8 
                                                                                at P=3.5 bar. 
                                                                                Appendix Pg:A-14*/
    final constant Real cp(unit = "kJ/kg.K") = 1.005 "specific heat constant of air";
    final constant Real R(final unit = "kJ/kmol.K") = 8.314 "gas constant";
    final constant Real M(final unit = "kg/kmol") = 28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real SigmaCond(unit = "kW/K") "entropy production rate in condenser";
    Real SigmaComp(unit = "kW/K") "entropy production rate in compressor";
    Real SigmaValve(unit = "kW/K") "entropy production rate in valve";
    Real mair(unit = "kg/s") "mass flow rate of air";
    Real mref(unit = "kg/s") "mass flow rate of refrigerant";
    Real del_h65(unit = "kJ/kg") "change in specific enthalpy of air through condensor";
    Real del_s65(unit = "kJ/kg.K") "change in specific entropy of air through condensor";
    Real v5(unit = "m3/kg") "specific volume of air at state 5";
    Real h4(unit = "kJ/kg") "specific enthalpy of refrigerant at state 4";
    Real s4(unit = "kJ/kg.K") "specific entropy of refrigerant at state 4";
    Real x4(unit = "-") "vapour quality of refrigerant at state 4";
    //===============================
    
    //equation selection
  equation
    h3 = h4;                                              //Throttling process
    x4 = (h4 - hf4) / hfg4;                               //Quality of vapour
    s4 = sf4 + x4 * (sg4 - sf4);                          //Entropy for liquid-vapour mixture
    v5 = R / M * (T5 + 273.15) * 10 ^ 3 / (p5 * 10 ^ 5);  //Ideal gas equation
                                                          //Multiplying by 10^5 to convert into Pa
                                                          //Multiplying by 10^3 to convert into J
    mair = AV5 / v5;
    del_h65 = cp * (T6 - T5);
    mref = mair * del_h65 / (h2 - h3);
    del_s65 = cp * log((T6 + 273.15) / (T5 + 273.15)) - R * log(p6 / p5);
                                                          //From Eq 6.22, Pg:186
    SigmaCond = mref * (s3 - s2) + mair * del_s65;
    SigmaComp = mref * (s2 - s1);
    SigmaValve = mref * (s4 - s3);                        //Entropy balance
  end Ex6_8_a;

  //===============================
end Ex6_8;
/*The  answer may slightly vary due to rounding off values
Variable name        Book value       Obtained value
Sigmacond            0.000795         0.00069995*/
