/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_3 Page:237
//Title:Evaluating Exergy Destruction in an Oven Wall
//===============================
package Ex7_3
  model Ex7_3_a
  //To find heat transfer rate per unit area
    
      //parameter selection
      parameter Real T1(unit = "K") = 575 "temperature of inner metal sheet";
      parameter Real T2(unit = "K") = 310 "temperature of outer metal sheet";
      parameter Real T0(unit = "K") = 293 "temperature at the dead state";
      parameter Real k(unit = "kW/m.K") = 0.05e-3 "thermal conductivity";
      parameter Real L(unit = "m") = 0.066 "insulation thickness";
      //===============================
      
      //variable selection
      Real QA(unit = "kW/m2") "heat transfer rate per unit area";
      //===============================
      
      //equation selection
      equation
        QA = -k * ((T2 - T1) / L);      //From Eq 2.31, Pg:31
  end Ex7_3_a;
  //===============================

  model Ex7_3_b
  //To find exergy transfer rate accompanying heat transfer
  
      //===============================
      extends Ex7_3_a;
      //===============================
      
      //variable selection
      Real Eq1A(unit="kW/m2")"exergy transfer rate accompanying heat transfer at inner surface";
      Real Eq2A(unit="kW/m2")"exergy transfer rate accompanying heat transfer at outer surface";
      //===============================
      
      //equation selection
      equation
        Eq1A=(1-(T0/T1))*QA;
        Eq2A=(1-(T0/T2))*QA;     //From Eq 7.12, Pg:237
  
  end Ex7_3_b;
  //===============================

  model Ex7_3_c
  //To find exergy destruction rate
  
      //===============================
      extends Ex7_3_a;
      extends Ex7_3_b;
      //===============================
      
      //variable selection
      Real EdA(unit="kW/m2")"exergy destruction rate per unit area";
      //===============================
      
      //equation selection
      equation
      EdA=Eq1A-Eq2A;      //From Eq 7.11(b), Pg:237
  
  end Ex7_3_c;
  //===============================
//The  answer may slightly vary due to  rounding off values
    
/*Variable       Obtained answer      Book answer
Eq1A             0.0984585            0.1
Eq2A             0.0110093            0.01
EdA              0.0874492            0.09 */
end Ex7_3;
