/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_6 Page:244
//Title:Evaluating Exergy Destruction in a Heat Exchanger
//===============================
package Ex7_6
  model Ex7_6_a
  //To find the exit temperature of the combustion gas
  
      //parameter selection
      parameter Real h1(unit="kJ/kg")=617.53"specific enthalpy of air at state 1"; 
                                                                            /*From Table A-22 
                                                                            for T=610 K. 
                                                                            Appendix Pg:A-39*/
      parameter Real h2(unit="kJ/kg")=888.27"specific enthalpy of air at state 2"; 
                                                                            /*From Table A-22 
                                                                            for T=860 K. 
                                                                            Appendix Pg:A-40*/
      parameter Real h3(unit="kJ/kg")=1068.89"specific enthalpy of combustion gas at state 3";
                                                                            /*From Table A-22 
                                                                            for T=1020 K. 
                                                                            Appendix Pg:A-40*/
      parameter Real ha(unit="kJ/kg")=789.11 "specific enthalpy a";
      parameter Real hb(unit="kJ/kg")=800.03 "specific enthalpy b";
      parameter Real Ta(unit="K")=770"temperature a";
      parameter Real Tb(unit="K")=780"temperature b";
                                                                            /*From Table A-22 
                                                                            for h=798.15 kJ/kg 
                                                                            for interpolating T. 
                                                                            Appendix Pg:A-40*/
      //===============================
      
      //variable selection 
      Real h4(unit="kJ/kg")"specific enthalpy of combustion gas at state 2";
      Real T4(unit="K")"exit temperature of combustion gas"; 
      //===============================
      
      //equation selection
      equation
        h4=h3+h1-h2;
        (T4-Ta)/(Tb-Ta)=(h4-ha)/(hb-ha);     //Interpolation
  end Ex7_6_a;
  //===============================

  model Ex7_6_b
  //To find the net change in the flow exergy rate from inlet to exit
  
      //===============================
      extends Ex7_6_a;
      //===============================
      
      //parameter selection
      parameter Real p1(unit="bar")=10"pressure of air at state 1";
      parameter Real p2(unit="bar")=9.7"pressure of air at state 2";
      parameter Real p3(unit="bar")=1.1"pressure of combustion gas at state 3";
      parameter Real p4(unit="bar")=1"pressure of combustion gas at state 4";
      parameter Real m(unit="kg/s")=90"mass flow rate of air";
      parameter Real T0(unit="K")=300"temperature at the dead state";
      parameter Real s1(unit="kJ/kg.K")=2.42644"specific entropy of air at state 1";
                                                                                /*From Table A-22 
                                                                                for T=610 K. 
                                                                                Appendix Pg:A-39*/
      parameter Real s2(unit="kJ/kg.K")=2.79783"specific entropy of air at state 2";
                                                                                /*From Table A-22 
                                                                                for T=860 K. 
                                                                                Appendix Pg:A-40*/  
      parameter Real s3(unit="kJ/kg.K")=2.99034"specific entropy of combustion gas at state 3";
                                                                                /*From Table A-22 
                                                                                for T=1020 K. 
                                                                                Appendix Pg:A-40*/  
      parameter Real s4(unit="kJ/kg.K")=2.68769"specific entropy of combustion gas at state 4";
                                                                                /*From Table A-22 
                                                                                for T=778 K. 
                                                                                Appendix Pg:A-40*/
  
      final constant Real R(final unit="kJ/kmol.K")=8.314 "gas constant";
      final constant Real M(final unit="kg/kmol")=28.97 "molecular mass of air";
      //===============================
      
      //variable selection
      Real del_ea(unit="MW")"net change in flow exergy rate for air";
      Real del_ecg(unit="MW")"net change in flow exergy rate for combustion gas";   
      //===============================
       
      //equation selection
      equation
        del_ea=m*((h2-h1)-T0*(s2-s1-(R/M)*log(p2/p1)))/10^3;     //From Eq 7.18, Pg:242
        del_ecg=m*((h4-h3)-T0*(s4-s3-(R/M)*log(p4/p3)))/10^3;    //Dividing by 10^3 to convert into MW
        
  end Ex7_6_b;
  //===============================

  model Ex7_6_c
  //To find rate of exergy destruction
  
      //===============================
      extends Ex7_6_b;
      //===============================
      
      //variable selection
      Real Ed(unit="MW")"rate of exergy destruction";
      //===============================
      
      //equation selection
      equation
        Ed=-del_ea-del_ecg;
        
  end Ex7_6_c;
//===============================

end Ex7_6;
