/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_8 Page:247
//Title:Exergy Accounting of a Steam Turbine
//===============================
model Ex7_8

    //parameter selection
    parameter Real Wcvm(unit="kJ/kg")=540"work developed per unit mass";
    parameter Real Qcvm(unit="kJ/kg")=-22.6"heat transfer per unit mass";
    parameter Real T0(unit="C")=25"temperature at the dead state";
    parameter Real p0(unit="atm")=1"pressure at the dead state";
    parameter Real h1(unit="kJ/kg")=3230.9"specific enthalpy at inlet";
    parameter Real s1(unit="kJ/kg.K")=6.9212"specific entropy at inlet";       /*From Table A-4 
                                                                             at P=30 bar and T=400 C. 
                                                                             Appendix Pg:A-8*/
    parameter Real h2(unit="kJ/kg")=2676.1"specific enthalpy at exit";
    parameter Real s2(unit="kJ/kg.K")=7.3549"specific entropy at exit";        /*From Table A-2 at T=100 C 
                                                                             for saturted vapour. 
                                                                             Appendix Pg:A-4*/
    parameter Real V1(unit="m/s")=160"velocity at inlet";
    parameter Real V2(unit="m/s")=100"velocity at exit";
    parameter Real Tb(unit="K")=350"temperature of outer surface";
    //===============================
    
    //variable selection
    Real del_e(unit="kJ/kg")"net exergy carried in per unit mass";
    Real Edm(unit="kJ/kg")"rate of exergy destruction";
    Real tot_Ed(unit="Btu/min")"total disposition of exergy";
    String result;
    //===============================
      
    //equation selection
    equation
        del_e=h1-h2-(T0+273.15)*(s1-s2)+(V1^2-V2^2)/(2*10^3);    //From Eq 7.18 Pg:242       
                                                                 //Dividing by 10^3 to convert into kJ        
        Edm=(1-(T0+273.15)/Tb)*Qcvm-Wcvm+del_e;                  //From Eq 7.18 Pg:242                                                                  
        tot_Ed=Wcvm+Edm-Qcvm*(1-(T0+273.15)/Tb);                 //Adding 273.15 to convert into Kelvin scale                                                   
        
        if del_e == tot_Ed then
          result = "exergy balance sheet satisfied";
        else
          result = "exergy balance sheet not satisfied";
        end if;
        
        Modelica.Utilities.Streams.print(result);

end Ex7_8;
//===============================
