/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_9 Page:248
//Title:Exergy Accounting of a Waste Heat Recovery System
//===============================
package Ex7_9
  model Ex7_9_a
  //To develop a full accounting of the net exergy
    
      //parameter selection
      parameter Real p1(unit = "atm") = 1 "presuure of combustion products at state 1";
      parameter Real p2(unit = "atm") = 1 "pressure of combustion products at state 2";
      parameter Real x5(unit = "-") = 0.93 "exit water vapour quality";
      parameter Real h1(unit = "Btu/lb") = 206.46 "specific enthalpy of combustion product at state 1";
      parameter Real s1(unit = "Btu/lb.R") = 0.71323 "specific entropy of combustion product at state 1";
                                                                                 /*From Table A-22E at T=860 R.
                                                                                  Appendix Pg:A-89*/
      parameter Real h2(unit = "Btu/lb") = 172.39 "specific enthalpy of combustion product at state 2";
      parameter Real s2(unit = "Btu/lb.R") = 0.67002 "specific entropy of combustion product at state 2";
                                                                                 /*From Table A-22E at T=720 R.
                                                                                  Appendix Pg:A-89*/
      parameter Real h3(unit = "Btu/lb") = 70.0 "specific enthalpy of water at state 3";
      parameter Real s3(unit = "Btu/lb") = 0.1331 "specific entropy of water at state 3";
                                                                                 /*From Table A-2E by 
                                                                                 interpolating T=100 and T=110 
                                                                                 values to T=102 F. 
                                                                                 Appendix Pg:A-51*/
      parameter Real s4(unit = "Btu/lb") = 1.7336 "specific entropy of water at stste 4";                                                                 
      parameter Real hg5(unit = "Btu/lb") = 1105.74 "specific enthalpy of saturated vapour at state 5";
      parameter Real hf5(unit = "Btu/lb") = 69.74 "specific enthalpy of saturated liquid at state 5";
      parameter Real s5(unit = "Btu/lb") = 1.8488 "specific entropy of water at state 5";
                                                                                 /*From Table A-3E at P=1 lbf/in^2.
                                                                                  Appendix Pg:A-53*/
      parameter Real m3(unit = "lb/min") = 275 "mass flow rate of water";
      parameter Real m1(unit = "lb/min") = 9230.6 "mass flow rate of combustion products";
      parameter Real T0(unit = "R") = 537 "temperature of dead state";
      parameter Real Wcv(unit = "Btu/min") = 49610 "power developed";            /*From solution of Ex 4.10*/
      final constant Real R(final unit = "ft.lbf/lb-mol.R") = 1545.33 "gas constant";
      final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
      //===============================
      
      //variable selection
      Real del_e21(unit = "Btu/min") "net exergy rate carried into the control volume";
      Real del_e35(unit = "Btu/min") "net exergy rate carried out by water system";
      Real Eds(unit = "Btu/min") "exergy destruction rate in steam generator";
      Real Edt(unit = "Btu/min") "exergy destruction rate in turbine";
      Real tot_Ed(unit = "Btu/min") "total disposition of exergy";
      Real h5(unit = "Btu/lb") "specific enthalpy at state 5";
      Real h4(unit = "Btu/lb") "specific enthalpy at state 4";
      String result;
      //===============================
      
      //equation selection
      equation
        h4 = h3 + m1 / m3 * (h1 - h2);
        h5 = hf5 + x5 * (hg5 - hf5);
        del_e21 = m1 * (h1 - h2 - T0 * (s1 - s2 - R / M * log(p1 / p2)));
        del_e35 = m3 * (h5 - h3 - T0 * (s5 - s3));               //From Eq.7.18, Pg:242
        Eds = del_e21 + m3 * (h3 - h4 - T0 * (s3 - s4));
        Edt = (-Wcv) + m3 * (h4 - h5 - T0 * (s4 - s5));          //Energy rate balance
        tot_Ed = Wcv + del_e35 + Eds + Edt;
        
        if del_e21 == tot_Ed then
          result = "exergy balance sheet satisfied";
        else
          result = "exergy balance sheet not satisfied";
        end if;
        
        Modelica.Utilities.Streams.print(result);
    
  end Ex7_9_a;
  //===============================
end Ex7_9;
