/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_6 Page:290
//Title:Considering a Reheat–Regenerative Cycle with Two Feedwater Heaters
//===============================
package Ex8_6
  model Ex8_6_a
  //To find thermal efficiency
      
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 3348.4 "specific enthalpy at state 1";
      parameter Real s1(unit = "kJ/kg.K") = 6.6586 "specific entropy at state 1";
                                                                /*From Table A-4 for
                                                                P=8.0 MPa and T=480 C. 
                                                                Appendix Pg"A-8*/
      parameter Real p2(unit = "MPa") = 2.0 "pressure at state 2";
      parameter Real h2(unit = "kJ/kg") = 2963.5 "specific enthalpy at state 2";
                                                                /*From Table A-4 for
                                                                P=2.0 MPa and s=6.6586 kJ/kg.
                                                                Appendix Pg"A-8*/
      parameter Real h3(unit = "kJ/kg") = 2741.8 "specific enthalpy at state 3";
      parameter Real h4(unit = "kJ/kg") = 3353.3 "specific enthalpy at state 4";
      parameter Real s4(unit = "kJ/kg.K") = 7.7571 "specific entropy at state 4";
                                                                /*From Table A-4 for 
                                                                P=0.7 MPa and T=440 C. 
                                                                Appendix Pg:A-8*/
      parameter Real p5(unit = "MPa") = 0.3 "pressure at state 5";
      parameter Real h5(unit = "kJ/kg") = 3101.5 "specific enthalpy at state 5";
                                                                /*From Table A-4 for 
                                                                P=0.3 MPa and s=7.7571 kJ/kg. 
                                                                Appendix Pg:A-8*/
      parameter Real hf6(unit = "kJ/kg") = 173.88 "specific enthalpy of saturated liquid at state 6";
      parameter Real hfg6(unit = "kJ/kg") = 2403.1 "specific enthalpy difference at state 6";
      parameter Real sf6(unit = "kJ/kg.K") = 0.5926 "specific entropy od saturated liquid at state 6";
      parameter Real sg6(unit = "kJ/kg.K") = 8.2287 "specific entropy of saturated vapour at state 6";
                                                                /*From Table A-3 for 
                                                                P=0.008 MPa. 
                                                                Appendix Pg:A-5*/
      parameter Real p7(unit = "MPa") = 0.008 "pressure at state 7";
      parameter Real h7(unit = "kJ/kg") = 173.88 "specific enthalpy at state 7";
      parameter Real v7(unit = "m3/kg") = 1.0084e-3 "specific volume at state 7";
                                                                /*From Table A-3 for 
                                                                P=0.008 MPa. 
                                                                Appendix Pg:A-5*/
      parameter Real p8(unit = "MPa") = 0.3 "pressure at state 8";
      parameter Real p9(unit = "MPa") = 0.3 "pressure at state 9";
      parameter Real h9(unit = "kJ/kg") = 561.47 "specific enthalpy at state 9";
      parameter Real v9(unit = "m3/kg") = 1.0732e-3 "specific volume at state 9";
                                                                /*From Table A-3 for 
                                                                P=0.3 MPa. 
                                                                Appendix Pg:A-5*/
      parameter Real p10(unit = "MPa") = 8.0 "pressure at state 10";
      parameter Real p11(unit = "MPa") = 8.0 "pressure at state 11";
      parameter Real psat(unit = "MPa") = 1.73 "saturation pressure at state 11";
      parameter Real hf11(unit = "MPa") = 875.1 "saturated liquid specific enthalpy at state 11";
      parameter Real vf11(unit = "m3/kg") = 1.1646e-3 "specific volume of saturated liquid at state 11";
                                                                /*From Table A-2 for T=205 C. 
                                                                Appendix Pg:A-4*/
      parameter Real h12(unit = "kJ/kg") = 908.79 "specific enthalpy at state 12";
      parameter Real h13(unit = "kJ/kg") = 908.79 "specific enthalpy at state 13";
                                                                /*From Table A-3 for 
                                                                P=2.0MPa. 
                                                                Appendix Pg:A-5*/
      //===============================
      
      //variable selection                                                          
      Real s2(unit = "kJ/kg.K") "specific entropy at state 2";
      Real s6(unit = "kJ/kg.K") "specific entropy at state 6";
      Real s5(unit = "kJ/kg.K") "specific entropy at state 5";
      Real x6(unit = "-") "quality of vapour at state 6";
      Real h6(unit = "kJ/kg") "specific enthalpy at state 6";
      Real h8(unit = "kJ/kg") "specific enthalpy at state 8";
      Real h10(unit = "kJ/kg") "specific enthalpy at state 10";
      Real h11(unit = "kJ/kg") "specific enthalpy at state 11";
      Real y1(unit = "-") "fraction of total flow diverted to the closed heater";
      Real y2(unit = "-") "fraction of total flow diverted to the open heater";
      Real Wt1_m1(unit = "kJ/kg") "work developed by the first turbine per unit of mass";
      Real Wt2_m1(unit = "kJ/kg") "work developed by the second turbine per unit of mass";
      Real Wp1_m1(unit = "kJ/kg") "work developed by the first pump per unit of mass";
      Real Wp2_m1(unit = "kJ/kg") "work developed by the second pump per unit of mass";
      Real Qin_m1(unit = "kJ/kg") "total heat added per unit of mass";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        s1 = s2;
        s6 = s4;
        s5 = s4;
        x6 = (s6 - sf6) / (sg6 - sf6);                             //Quality of liquid-vapour mixture
        h6 = hf6 + x6 * hfg6;                                      //Enthalpy of liquid-vapour mixture
        h8 = h7 + v7 * (p8 - p7);
        h10 = h9 + v7 * (p10 - p9);
        h11 = hf11 + vf11 * (p11 - psat);                          //From Eq. 3.13, Pg:82
        y1 = (h11 - h10) / (h2 - h12);
        0 = y2 * h5 + (1 - y1 - y2) * h8 + y1 * h13 - h9;          //From Example 8.6, Pg:291
        Wt1_m1 = h1 - h2 + (1 - y1) * (h2 - h3);
        Wt2_m1 = (1 - y1) * (h4 - h5) + (1 - y1 - y2) * (h5 - h6); //Modified equation of Eq. 8.1, Pg:270
        Wp2_m1 = h10 - h9;
        Wp1_m1 = (1 - y1 - y2) * (h8 - h7);                        //Modified equation of Eq. 8.3, Pg:270
        Qin_m1 = h1 - h11 + (1 - y1) * (h4 - h3);                  //Modified equation of Eq. 8.4, Pg:270
        n = (Wt1_m1 + Wt2_m1 - Wp1_m1 - Wp2_m1) / Qin_m1;          //Thermal efficiency
  end Ex8_6_a;
  //===============================

  model Ex8_6_b
  //To find mass flow rate
  
      //===============================
      extends Ex8_6_a;
      //===============================
      
      //parameter selection
      parameter Real Wcv(unit="MW")=100"net power output";
      //===============================
      
      //variable selection
      Real m1(unit="kg/h")"mass flow rate";
      //===============================
      
      //equation selection
      equation
        m1=Wcv*3600*10^3/(Wt1_m1+Wt2_m1-Wp1_m1-Wp2_m1);           //From net work Eq given in part (a) Pg:278
                                                                  //Multiplying by 10^3 to convert into kW
                                                                  //Multiplying by 3600 to convert into per hour
  end Ex8_6_b;
  //===============================
end Ex8_6;
