/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_7 Page:298
//Title:Vapor Cycle Exergy Analysis—Heat Exchanger Unit
//===============================
package Ex8_7
  model Ex8_7_a
  //To find net exergy rate carried in by the gaseous stream
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 2758 "specific enthalpy of water at state 1";
      parameter Real h4(unit = "kJ/kg") = 183.36 "specific enthalpy of water at state 4";
      parameter Real m(unit = "kg/h") = 4.449e5 "mass flow rate of water";
                                                                   /*From solution to 
                                                                   Example 8.2, Pg:278*/
      parameter Real hi(unit = "kJ/kg") = 1491.44 "specific enthalpy of air at inlet";
      parameter Real si(unit = "kJ/kg.K") = 3.34474 "specific entropy of air at inlet";
                                                                   /*From table A-22 at 
                                                                   P=1 atm and T=1107 C. 
                                                                   Appendix Pg:A-40*/
      parameter Real he(unit = "kJ/kg") = 843.98 "specific enthalpy of air at exit";
      parameter Real se(unit = "kJ/kg.K") = 2.74504 "specific entropy of air at exit";
                                                                   /*From table A-22 at 
                                                                   P=1 atm and T=547 C. 
                                                                   Appendix Pg:A-40*/
      parameter Real T0(unit = "K") = 295 "temperature at the dead state";
      //===============================
      
      //variable selection
      Real ma(unit = "kg/h") "mass flow rate of air";
      Real net_egas(unit = "MW") "net exergy rate carried in by the gaseous stream";
      //===============================
      
      //equation selection
      equation
        ma / m = (h1 - h4) / (hi - he);                                  //Reduced energy rate balance
        net_egas = ma * (hi - he - T0 * (si - se)) / (3600 * 10 ^ 3);    //Net exergy rate
                                                                         //Dividing by (3600*10^3) to convert into MW
  end Ex8_7_a;
  //===============================

  model Ex8_7_b
  //To find net exergy rate carried in by the water stream
      
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 2758 "specific enthalpy of water at state 1";
      parameter Real s1(unit = "kJ/kg.K") = 5.7432 "specific entropy of air at inlet";
      parameter Real h4(unit = "kJ/kg") = 183.36 "specific enthalpy of water at state 4";
      parameter Real s4(unit = "kJ/kg.K") = 0.5957 "specific entropy of air at exit";
                                                                     /*From solution to 
                                                                     Example 8.2, Pg:278*/
      parameter Real T0(unit = "K") = 295 "temperature at the dead state";
      parameter Real m(unit = "kg/h") = 4.449e5 "mass flow rate of water";
      //===============================
      
      //variable selection      
      Real net_ewat(unit = "MW") "net exergy rate carried in by the water stream";
      //===============================
      
      //equation selection
      equation
        net_ewat = m * (h1 - h4 - T0 * (s1 - s4)) / (3600 * 10 ^ 3); //Net exergy rate
                                                                     //Dividing by (3600*10^3) to convert into MW
  end Ex8_7_b;
  //===============================

  model Ex8_7_c
  //To find rate of exergy destruction
  
      //===============================
      extends Ex8_7_a;
      extends Ex8_7_b;
      //===============================
      
      //variable selection      
      Real Ed(unit = "MW") "rate of exergy destruction";
      //===============================
      
      //equation selection
      equation
        Ed = net_egas - net_ewat;  //Reduced exergy rate balance
      
  end Ex8_7_c;
  //===============================

  model Ex8_7_d
  //To find Exergetic efficiency
  
      //===============================
      extends Ex8_7_a;
      extends Ex8_7_b;
      //===============================
      
      //variable selection
      Real e(unit = "-") "exergetic efficiency";
      //===============================
      
      //equation selection
      equation
        e = net_ewat / net_egas;   //Exergetic efficiency
      
  end Ex8_7_d;
  //===============================  
end Ex8_7;
