/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_9 Page:300
//Title:Vapor Cycle Exergy Analysis—Condenser
//===============================
package Ex8_9
  model Ex8_9_a
  //To find net rate of exergy carried out by cooling water
          
      //parameter selection
      parameter Real mcw(unit = "kg/h") = 9.39e6 "mass flow rate of water";
      parameter Real net_egas(unit = "MW") = 231.28 "rate to exergy supply by cooling combustion gas";
                                                                              /*From solution to 
                                                                              Example 8.2, Pg:278*/
      parameter Real hi(unit = "kJ/kg") = 62.99 "specific enthalpy of saturated liquid at inlet";
      parameter Real si(unit = "kJ/kg.K") = 0.2245 "specific entropy of saturated liquid at inlet";
                                                                              /*From Table A-2 
                                                                              at T=15 C. Appendix Pg:A-3*/
      parameter Real he(unit = "kJ/kg") = 146.68 "specific enthalpy of saturated liquid at exit";
      parameter Real se(unit = "kJ/kg.K") = 0.5053 "specific entropy of saturated liquid at exit";
                                                                              /*From Table A-2 
                                                                              at T=35 C. Appendix Pg:A-3*/
      parameter Real T0(unit = "K") = 295 "temperature at the dead state";    
      parameter Real fuel(unit = "-")=0.69"percentage of exergy entering the plant with the fuel remains";
      //===============================
      
      //variable selection
      Real percent_ecw(unit="%")"percentage of rate at which exergy is carried into the plant with fuel";
      Real net_ecw(unit = "MW") "net exergy rate carried out by cooling water";
      //===============================
      
      //equation selection
      equation
       net_ecw = mcw * (he - hi - T0 * (se - si)) / (3600 * 10 ^ 3);  //Net exergy rate
                                                                      //Dividing by (3600*10^3) to convert into MW
       percent_ecw=net_ecw/net_egas*fuel*100;    
  end Ex8_9_a;
  //===============================

  model Ex8_9_b
  //To find exergy destruction rate for condenser
  
      //===============================
      extends Ex8_9_a;
      //===============================
      
      //parameter selection
      parameter Real s2(unit="kJ/kg.K")=6.2021"specific entropy of two phase liq-vap mixture ar state 2";
      parameter Real s3(unit="kJ/kg.K")=0.5926"specific entropy of saturated liquid at state 3";
                                                                              /*From Table A-3 
                                                                              at P=0.008 MPa. 
                                                                              Appendix Pg:A-5*/
      parameter Real m(unit="kg/h")=4.449e5"mass flow rate of water";
                                                                              /*From solution to 
                                                                              Example 8.2, Pg:278*/
      //===============================
      
      //variable selection
      Real Ed(unit="MW")"exergy destruction rate for condenser";
      Real percent_Ed(unit="%")"percent of exergy entering the plant with fuel";
      //===============================
      
      //equation selection
      equation
        Ed=T0*(m*(s3-s2)+mcw*(se-si))/(3600*10^3);  //Net exergy rate
                                                    //Dividing by (3600*10^3) to convert into MW
        percent_Ed=Ed/net_egas*fuel*100;
  end Ex8_9_b;
  //===============================
  
end Ex8_9;
//===============================
//The  answer may slightly vary due to  rounding off values
/*Variable       Obtained answer      Book answer
percent_Ed       3.44818%             3%
percent_ecw      0.664557%            1%  */
